/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.p3c.pmd.lang.java.rule.other;

import com.alibaba.p3c.pmd.lang.AbstractXpathRule;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import org.apache.commons.lang3.StringUtils;

public class UseRightCaseForDateFormatRule
extends AbstractXpathRule {
    private static final String NEW_XPATH = "//AllocationExpression/ClassOrInterfaceType[@Image='SimpleDateFormat']/../Arguments/ArgumentList/Expression/PrimaryExpression/PrimaryPrefix/*";
    private static final String LOW_CASE_4Y = "yyyy";
    private static final String LOW_CASE_2Y = "yy";
    private static final String START_QUOTE = "\"";

    public UseRightCaseForDateFormatRule() {
        this.setXPath(NEW_XPATH);
    }

    public void addViolation(Object data, Node node, String arg) {
        this.checkNode(node, data);
    }

    private void checkNode(Node argNode, Object data) {
        String image = "";
        if (argNode instanceof ASTLiteral) {
            image = argNode.getImage();
        }
        if (StringUtils.isEmpty((CharSequence)image) || !image.startsWith(START_QUOTE)) {
            return;
        }
        image = image.replace(START_QUOTE, "");
        String lowerCaseTmp = image.toLowerCase();
        if (!image.startsWith(LOW_CASE_4Y) && lowerCaseTmp.startsWith(LOW_CASE_4Y)) {
            this.addViolationWithMessage(data, argNode, "java.other.UseRightCaseForDateFormatRule.rule.msg", new Object[]{image});
        } else if (!image.startsWith(LOW_CASE_2Y) && lowerCaseTmp.startsWith(LOW_CASE_2Y)) {
            this.addViolationWithMessage(data, argNode, "java.other.UseRightCaseForDateFormatRule.rule.msg", new Object[]{image});
        }
    }
}

