/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.p3c.pmd.lang.java.rule.comment;

import com.alibaba.p3c.pmd.I18nResources;
import com.alibaba.p3c.pmd.lang.java.rule.comment.AbstractAliCommentRule;
import com.alibaba.p3c.pmd.lang.java.util.ViolationUtils;
import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTEnumDeclaration;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaNode;
import net.sourceforge.pmd.lang.java.ast.Comment;
import net.sourceforge.pmd.lang.rule.AbstractRule;

public class ClassMustHaveAuthorRule
extends AbstractAliCommentRule {
    private static final Pattern AUTHOR_PATTERN = Pattern.compile(".*@author.*", 32);
    private static final String MESSAGE_KEY_PREFIX = "java.comment.ClassMustHaveAuthorRule.violation.msg";

    public Object visit(ASTClassOrInterfaceDeclaration decl, Object data) {
        if (decl.isNested()) {
            return super.visit(decl, data);
        }
        if (!decl.isPublic()) {
            return super.visit(decl, data);
        }
        this.checkAuthorComment((AbstractJavaNode)decl, data);
        return super.visit(decl, data);
    }

    public Object visit(ASTEnumDeclaration decl, Object data) {
        if (!decl.isPublic()) {
            return super.visit(decl, data);
        }
        ASTClassOrInterfaceDeclaration parent = (ASTClassOrInterfaceDeclaration)decl.getFirstParentOfType(ASTClassOrInterfaceDeclaration.class);
        if (parent != null) {
            return super.visit(decl, data);
        }
        this.checkAuthorComment((AbstractJavaNode)decl, data);
        return super.visit(decl, data);
    }

    public Object visit(ASTCompilationUnit cUnit, Object data) {
        this.assignCommentsToDeclarations(cUnit);
        return super.visit(cUnit, data);
    }

    public void checkAuthorComment(AbstractJavaNode decl, Object data) {
        Comment comment = decl.comment();
        if (null == comment) {
            ViolationUtils.addViolationWithPrecisePosition((AbstractRule)this, (Node)decl, data, I18nResources.getMessage("java.comment.ClassMustHaveAuthorRule.violation.msg.comment", decl.getImage()));
        } else {
            String commentContent = comment.getImage();
            boolean hasAuthor = AUTHOR_PATTERN.matcher(commentContent).matches();
            if (!hasAuthor) {
                ViolationUtils.addViolationWithPrecisePosition((AbstractRule)this, (Node)decl, data, I18nResources.getMessage("java.comment.ClassMustHaveAuthorRule.violation.msg.author", decl.getImage()));
            }
        }
    }
}

