/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.spring.context.event;

import com.alibaba.nacos.spring.context.event.config.NacosConfigMetadataEvent;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;

public class LoggingNacosConfigMetadataEventListener
implements ApplicationListener<NacosConfigMetadataEvent> {
    public static final String BEAN_NAME = "loggingNacosConfigMetadataEventListener";
    private static final String LOGGING_MESSAGE = "Nacos Config Metadata : dataId='{}', groupId='{}', beanName='{}', bean='{}', beanType='{}', annotatedElement='{}', xmlResource='{}', nacosProperties='{}', nacosPropertiesAttributes='{}', source='{}', timestamp='{}'";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void onApplicationEvent(NacosConfigMetadataEvent event) {
        if (!this.logger.isInfoEnabled()) {
            return;
        }
        this.logger.info(LOGGING_MESSAGE, new Object[]{event.getDataId(), event.getGroupId(), event.getBeanName(), event.getBean(), event.getBeanType(), event.getAnnotatedElement(), event.getXmlResource(), this.obscuresNacosProperties(event.getNacosProperties()), event.getNacosPropertiesAttributes(), event.getSource(), event.getTimestamp()});
    }

    private String obscuresNacosProperties(Map<Object, Object> nacosProperties) {
        String nacosPropertyStr;
        if (nacosProperties != null && nacosProperties.size() > 0) {
            StringBuilder sb = new StringBuilder("{");
            int size = nacosProperties.size();
            int idx = 0;
            for (Map.Entry<Object, Object> e : nacosProperties.entrySet()) {
                Object key = e.getKey();
                Object value = e.getValue();
                sb.append(key);
                sb.append('=');
                if (key != null && "password".equals(key.toString())) {
                    sb.append("******");
                } else {
                    sb.append(value);
                }
                if (idx < size - 1) {
                    sb.append(", ");
                }
                ++idx;
            }
            sb.append("}");
            nacosPropertyStr = sb.toString();
        } else {
            nacosPropertyStr = "{}";
        }
        return nacosPropertyStr;
    }
}

