/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.http;

import com.alibaba.nacos.common.utils.StringUtils;
import java.net.URI;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpHead;
import org.apache.hc.client5.http.classic.methods.HttpPatch;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpTrace;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;

public enum BaseHttpMethod {
    GET("GET"){

        @Override
        protected HttpUriRequestBase createRequest(String url) {
            return new HttpGet(url);
        }
    }
    ,
    GET_LARGE("GET-LARGE"){

        @Override
        protected HttpUriRequestBase createRequest(String url) {
            return new HttpGetWithEntity(url);
        }
    }
    ,
    POST("POST"){

        @Override
        protected HttpUriRequestBase createRequest(String url) {
            return new HttpPost(url);
        }
    }
    ,
    PUT("PUT"){

        @Override
        protected HttpUriRequestBase createRequest(String url) {
            return new HttpPut(url);
        }
    }
    ,
    DELETE("DELETE"){

        @Override
        protected HttpUriRequestBase createRequest(String url) {
            return new HttpDelete(url);
        }
    }
    ,
    DELETE_LARGE("DELETE_LARGE"){

        @Override
        protected HttpUriRequestBase createRequest(String url) {
            return new HttpDeleteWithEntity(url);
        }
    }
    ,
    HEAD("HEAD"){

        @Override
        protected HttpUriRequestBase createRequest(String url) {
            return new HttpHead(url);
        }
    }
    ,
    TRACE("TRACE"){

        @Override
        protected HttpUriRequestBase createRequest(String url) {
            return new HttpTrace(url);
        }
    }
    ,
    PATCH("PATCH"){

        @Override
        protected HttpUriRequestBase createRequest(String url) {
            return new HttpPatch(url);
        }
    }
    ,
    OPTIONS("OPTIONS"){

        @Override
        protected HttpUriRequestBase createRequest(String url) {
            return new HttpTrace(url);
        }
    };

    private String name;

    private BaseHttpMethod(String name) {
        this.name = name;
    }

    public HttpUriRequestBase init(String url) {
        return this.createRequest(url);
    }

    protected HttpUriRequestBase createRequest(String url) {
        throw new UnsupportedOperationException();
    }

    public static BaseHttpMethod sourceOf(String name) {
        for (BaseHttpMethod method : BaseHttpMethod.values()) {
            if (!StringUtils.equalsIgnoreCase(name, method.name)) continue;
            return method;
        }
        throw new IllegalArgumentException("Unsupported http method : " + name);
    }

    public static class HttpDeleteWithEntity
    extends HttpUriRequestBase {
        public static final String METHOD_NAME = "DELETE";

        public HttpDeleteWithEntity(String url) {
            super(METHOD_NAME, URI.create(url));
        }
    }

    public static class HttpGetWithEntity
    extends HttpUriRequestBase {
        public static final String METHOD_NAME = "GET";

        public HttpGetWithEntity(String url) {
            super(METHOD_NAME, URI.create(url));
        }
    }
}

