/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.api.remote;

import com.alibaba.nacos.api.remote.RequestCallBack;
import com.alibaba.nacos.api.remote.RequestFuture;
import com.alibaba.nacos.api.remote.RpcScheduledExecutor;
import com.alibaba.nacos.api.remote.response.Response;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class DefaultRequestFuture
implements RequestFuture {
    private long timeStamp = System.currentTimeMillis();
    private volatile boolean isDone = false;
    private boolean isSuccess;
    private RequestCallBack requestCallBack;
    private Exception exception;
    private String requestId;
    private String connectionId;
    private Response response;
    private ScheduledFuture timeoutFuture;
    FutureTrigger futureTrigger;

    public RequestCallBack getRequestCallBack() {
        return this.requestCallBack;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public DefaultRequestFuture(String connectionId, String requestId) {
        this(connectionId, requestId, null, null);
    }

    public DefaultRequestFuture(String connectionId, String requestId, RequestCallBack requestCallBack, FutureTrigger futureTrigger) {
        this.requestCallBack = requestCallBack;
        this.requestId = requestId;
        this.connectionId = connectionId;
        if (requestCallBack != null) {
            this.timeoutFuture = RpcScheduledExecutor.TIMEOUT_SCHEDULER.schedule(new TimeoutHandler(), requestCallBack.getTimeout(), TimeUnit.MILLISECONDS);
        }
        this.futureTrigger = futureTrigger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResponse(Response response) {
        this.isDone = true;
        this.response = response;
        this.isSuccess = response.isSuccess();
        if (this.timeoutFuture != null) {
            this.timeoutFuture.cancel(true);
        }
        DefaultRequestFuture defaultRequestFuture = this;
        synchronized (defaultRequestFuture) {
            this.notifyAll();
        }
        this.callBacInvoke();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFailResult(Exception e) {
        this.isDone = true;
        this.isSuccess = false;
        this.exception = e;
        DefaultRequestFuture defaultRequestFuture = this;
        synchronized (defaultRequestFuture) {
            this.notifyAll();
        }
        this.callBacInvoke();
    }

    private void callBacInvoke() {
        if (this.requestCallBack != null) {
            if (this.requestCallBack.getExecutor() != null) {
                this.requestCallBack.getExecutor().execute(new CallBackHandler());
            } else {
                new CallBackHandler().run();
            }
        }
    }

    public String getRequestId() {
        return this.requestId;
    }

    @Override
    public boolean isDone() {
        return this.isDone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response get() throws InterruptedException {
        DefaultRequestFuture defaultRequestFuture = this;
        synchronized (defaultRequestFuture) {
            while (!this.isDone) {
                this.wait();
            }
        }
        return this.response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response get(long timeout) throws TimeoutException, InterruptedException {
        if (timeout < 0L) {
            DefaultRequestFuture defaultRequestFuture = this;
            synchronized (defaultRequestFuture) {
                while (!this.isDone) {
                    this.wait();
                }
            }
        }
        if (timeout > 0L) {
            long end = System.currentTimeMillis() + timeout;
            long waitTime = timeout;
            DefaultRequestFuture defaultRequestFuture = this;
            synchronized (defaultRequestFuture) {
                while (!this.isDone && waitTime > 0L) {
                    this.wait(waitTime);
                    waitTime = end - System.currentTimeMillis();
                }
            }
        }
        if (this.isDone) {
            return this.response;
        }
        if (this.timeoutFuture == null && this.futureTrigger != null) {
            this.futureTrigger.triggerOnTimeout();
        }
        throw new TimeoutException("request timeout after " + timeout + " milliseconds, requestId=" + this.requestId + ", connectionId=" + this.connectionId);
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(boolean mayInterruptIfRunning) {
        boolean cancel;
        DefaultRequestFuture defaultRequestFuture = this;
        synchronized (defaultRequestFuture) {
            this.notifyAll();
        }
        if (this.timeoutFuture != null && !this.timeoutFuture.isDone() && (cancel = this.timeoutFuture.cancel(mayInterruptIfRunning)) && this.futureTrigger != null) {
            this.futureTrigger.triggerOnCancel();
        }
    }

    public static interface FutureTrigger {
        public void defaultTrigger();

        default public void triggerOnTimeout() {
            this.defaultTrigger();
        }

        default public void triggerOnCancel() {
            this.defaultTrigger();
        }
    }

    class TimeoutHandler
    implements Runnable {
        @Override
        public void run() {
            DefaultRequestFuture.this.setFailResult(new TimeoutException("Timeout After " + DefaultRequestFuture.this.requestCallBack.getTimeout() + " milliseconds, requestId=" + DefaultRequestFuture.this.requestId + ", connectionId=" + DefaultRequestFuture.this.connectionId));
            if (DefaultRequestFuture.this.futureTrigger != null) {
                DefaultRequestFuture.this.futureTrigger.triggerOnTimeout();
            }
        }
    }

    class CallBackHandler
    implements Runnable {
        CallBackHandler() {
        }

        @Override
        public void run() {
            if (DefaultRequestFuture.this.exception != null) {
                DefaultRequestFuture.this.requestCallBack.onException(DefaultRequestFuture.this.exception);
            } else {
                DefaultRequestFuture.this.requestCallBack.onResponse(DefaultRequestFuture.this.response);
            }
        }
    }
}

