/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.http;

import com.alibaba.nacos.common.http.param.Header;
import com.alibaba.nacos.common.http.param.MediaType;
import com.alibaba.nacos.common.http.param.Query;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.common.utils.UuidUtils;
import com.alibaba.nacos.common.utils.VersionUtils;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicNameValuePair;

public final class HttpUtils {
    private static final Pattern CONTEXT_PATH_MATCH = Pattern.compile("(\\/)\\1+");

    public static void initRequestHeader(HttpRequestBase requestBase, Header header) {
        Iterator<Map.Entry<String, String>> iterator = header.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            requestBase.setHeader(entry.getKey(), entry.getValue());
        }
    }

    public static void initRequestEntity(HttpRequestBase requestBase, Object body, Header header) throws Exception {
        if (body == null) {
            return;
        }
        if (requestBase instanceof HttpEntityEnclosingRequest) {
            HttpEntityEnclosingRequest request = (HttpEntityEnclosingRequest)requestBase;
            MediaType mediaType = MediaType.valueOf(header.getValue("Content-Type"));
            ContentType contentType = ContentType.create((String)mediaType.getType(), (String)mediaType.getCharset());
            Object entity = body instanceof byte[] ? new ByteArrayEntity((byte[])body, contentType) : new StringEntity(body instanceof String ? (String)body : JacksonUtils.toJson(body), contentType);
            request.setEntity((HttpEntity)entity);
        }
    }

    public static void initRequestFromEntity(HttpRequestBase requestBase, Map<String, String> body, String charset) throws Exception {
        if (body == null || body.isEmpty()) {
            return;
        }
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>(body.size());
        for (Map.Entry<String, String> entry : body.entrySet()) {
            params.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
        }
        if (requestBase instanceof HttpEntityEnclosingRequest) {
            HttpEntityEnclosingRequest request = (HttpEntityEnclosingRequest)requestBase;
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params, charset);
            request.setEntity((HttpEntity)entity);
        }
    }

    public static String buildUrl(boolean isHttps, String serverAddr, String ... subPaths) {
        StringBuilder sb = new StringBuilder();
        if (isHttps) {
            sb.append("https://");
        } else {
            sb.append("http://");
        }
        sb.append(serverAddr);
        String pre = null;
        for (String subPath : subPaths) {
            if (StringUtils.isBlank(subPath)) continue;
            Matcher matcher = CONTEXT_PATH_MATCH.matcher(subPath);
            if (matcher.find()) {
                throw new IllegalArgumentException("Illegal url path expression : " + subPath);
            }
            if (pre == null || !pre.endsWith("/")) {
                if (subPath.startsWith("/")) {
                    sb.append(subPath);
                } else {
                    sb.append('/').append(subPath);
                }
            } else if (subPath.startsWith("/")) {
                sb.append(subPath.replaceFirst("\\/", ""));
            } else {
                sb.append(subPath);
            }
            pre = subPath;
        }
        return sb.toString();
    }

    public static Map<String, String> translateParameterMap(Map<String, String[]> parameterMap) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>(16);
        for (Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
            map.put(entry.getKey(), entry.getValue()[0]);
        }
        return map;
    }

    public static String encodingParams(Map<String, String> params, String encoding) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        if (null == params || params.isEmpty()) {
            return null;
        }
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (StringUtils.isEmpty(entry.getValue())) continue;
            sb.append(entry.getKey()).append('=');
            sb.append(URLEncoder.encode(entry.getValue(), encoding));
            sb.append('&');
        }
        return sb.toString();
    }

    public static String encodingParams(List<String> paramValues, String encoding) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        if (null == paramValues) {
            return null;
        }
        Iterator<String> iter = paramValues.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next()).append('=');
            sb.append(URLEncoder.encode(iter.next(), encoding));
            if (!iter.hasNext()) continue;
            sb.append('&');
        }
        return sb.toString();
    }

    public static String decode(String str, String encode) throws UnsupportedEncodingException {
        return HttpUtils.innerDecode(null, str, encode);
    }

    public static URI buildUri(String url, Query query) throws URISyntaxException {
        if (query != null && !query.isEmpty()) {
            url = url + "?" + query.toQueryUrl();
        }
        return new URI(url);
    }

    public static boolean isTimeoutException(Throwable throwable) {
        return throwable instanceof SocketTimeoutException || throwable instanceof ConnectTimeoutException || throwable instanceof TimeoutException || throwable.getCause() instanceof TimeoutException;
    }

    public static Header builderHeader(String module) {
        Header header = Header.newInstance();
        header.addParam("Client-Version", VersionUtils.version);
        header.addParam("User-Agent", VersionUtils.getFullClientVersion());
        header.addParam("Accept-Encoding", "gzip,deflate,sdch");
        header.addParam("Requester", "Keep-Alive");
        header.addParam("RequestId", UuidUtils.generateUuid());
        header.addParam("Request-Module", module);
        return header;
    }

    private static String innerDecode(String pre, String now, String encode) throws UnsupportedEncodingException {
        if (StringUtils.equals(pre, now)) {
            return pre;
        }
        pre = now;
        now = URLDecoder.decode(now, encode);
        return HttpUtils.innerDecode(pre, now, encode);
    }
}

