/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.selector;

import com.alibaba.nacos.api.naming.listener.AbstractEventListener;
import com.alibaba.nacos.api.naming.listener.EventListener;
import com.alibaba.nacos.api.naming.listener.NamingEvent;
import com.alibaba.nacos.client.selector.ListenerInvoker;
import com.alibaba.nacos.client.utils.LogUtils;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

public class NamingListenerInvoker
implements ListenerInvoker<NamingEvent> {
    private final EventListener listener;
    private final AtomicBoolean invoked = new AtomicBoolean(false);

    public NamingListenerInvoker(EventListener listener) {
        this.listener = listener;
    }

    @Override
    public void invoke(NamingEvent event) {
        this.invoked.set(true);
        this.logInvoke(event);
        if (this.listener instanceof AbstractEventListener && ((AbstractEventListener)this.listener).getExecutor() != null) {
            ((AbstractEventListener)this.listener).getExecutor().execute(() -> this.listener.onEvent(event));
        } else {
            this.listener.onEvent(event);
        }
    }

    private void logInvoke(NamingEvent event) {
        LogUtils.NAMING_LOGGER.info("Invoke event groupName: {}, serviceName: {} to Listener: {}", new Object[]{event.getGroupName(), event.getServiceName(), this.listener.toString()});
    }

    @Override
    public boolean isInvoked() {
        return this.invoked.get();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (this == o) {
            return true;
        }
        NamingListenerInvoker that = (NamingListenerInvoker)o;
        return Objects.equals(this.listener, that.listener);
    }

    public int hashCode() {
        return Objects.hashCode(this.listener);
    }
}

