/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.cache;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.api.naming.utils.NamingUtils;
import com.alibaba.nacos.client.env.NacosClientProperties;
import com.alibaba.nacos.client.monitor.MetricsMonitor;
import com.alibaba.nacos.client.naming.backups.FailoverReactor;
import com.alibaba.nacos.client.naming.cache.DiskCache;
import com.alibaba.nacos.client.naming.cache.InstancesDiffer;
import com.alibaba.nacos.client.naming.event.InstancesChangeEvent;
import com.alibaba.nacos.client.naming.event.InstancesDiff;
import com.alibaba.nacos.client.naming.utils.CacheDirUtil;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.common.lifecycle.Closeable;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.utils.ConvertUtils;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ServiceInfoHolder
implements Closeable {
    private final ConcurrentMap<String, ServiceInfo> serviceInfoMap;
    private final FailoverReactor failoverReactor;
    private final boolean pushEmptyProtection;
    private final InstancesDiffer instancesDiffer;
    private String cacheDir;
    private String notifierEventScope;

    public ServiceInfoHolder(String namespace, String notifierEventScope, NacosClientProperties properties) {
        this.cacheDir = CacheDirUtil.initCacheDir(namespace, properties);
        this.instancesDiffer = new InstancesDiffer();
        this.serviceInfoMap = this.isLoadCacheAtStart(properties) ? new ConcurrentHashMap<String, ServiceInfo>(DiskCache.read(this.cacheDir)) : new ConcurrentHashMap<String, ServiceInfo>(16);
        this.failoverReactor = new FailoverReactor(this, notifierEventScope);
        this.pushEmptyProtection = this.isPushEmptyProtect(properties);
        this.notifierEventScope = notifierEventScope;
    }

    private boolean isLoadCacheAtStart(NacosClientProperties properties) {
        boolean loadCacheAtStart = false;
        if (properties != null && StringUtils.isNotEmpty(properties.getProperty("namingLoadCacheAtStart"))) {
            loadCacheAtStart = ConvertUtils.toBoolean(properties.getProperty("namingLoadCacheAtStart"));
        }
        return loadCacheAtStart;
    }

    private boolean isPushEmptyProtect(NacosClientProperties properties) {
        boolean pushEmptyProtection = false;
        if (properties != null && StringUtils.isNotEmpty(properties.getProperty("namingPushEmptyProtection"))) {
            pushEmptyProtection = ConvertUtils.toBoolean(properties.getProperty("namingPushEmptyProtection"));
        }
        return pushEmptyProtection;
    }

    public Map<String, ServiceInfo> getServiceInfoMap() {
        return this.serviceInfoMap;
    }

    public ServiceInfo getServiceInfo(String serviceName, String groupName) {
        String key = NamingUtils.getGroupedName(serviceName, groupName);
        return (ServiceInfo)this.serviceInfoMap.get(key);
    }

    public ServiceInfo processServiceInfo(String json) {
        ServiceInfo serviceInfo = JacksonUtils.toObj(json, ServiceInfo.class);
        serviceInfo.setJsonFromServer(json);
        return this.processServiceInfo(serviceInfo);
    }

    public ServiceInfo processServiceInfo(ServiceInfo serviceInfo) {
        String serviceKey = serviceInfo.getKeyWithoutClusters();
        if (serviceKey == null) {
            LogUtils.NAMING_LOGGER.warn("process service info but serviceKey is null, service host: {}", (Object)JacksonUtils.toJson(serviceInfo.getHosts()));
            return null;
        }
        ServiceInfo oldService = (ServiceInfo)this.serviceInfoMap.get(serviceKey);
        if (this.isEmptyOrErrorPush(serviceInfo)) {
            LogUtils.NAMING_LOGGER.warn("process service info but found empty or error push, serviceKey: {}, pushEmptyProtection: {}, hosts: {}", new Object[]{serviceKey, this.pushEmptyProtection, serviceInfo.getHosts()});
            return oldService;
        }
        this.serviceInfoMap.put(serviceKey, serviceInfo);
        InstancesDiff diff = this.getServiceInfoDiff(oldService, serviceInfo);
        if (StringUtils.isBlank(serviceInfo.getJsonFromServer())) {
            serviceInfo.setJsonFromServer(JacksonUtils.toJson(serviceInfo));
        }
        MetricsMonitor.getServiceInfoMapSizeMonitor().set((double)this.serviceInfoMap.size());
        if (diff.hasDifferent()) {
            LogUtils.NAMING_LOGGER.info("current ips:({}) service: {} -> {}", new Object[]{serviceInfo.ipCount(), serviceKey, JacksonUtils.toJson(serviceInfo.getHosts())});
            if (!this.failoverReactor.isFailoverSwitch(serviceKey)) {
                NotifyCenter.publishEvent(new InstancesChangeEvent(this.notifierEventScope, serviceInfo.getName(), serviceInfo.getGroupName(), serviceInfo.getClusters(), serviceInfo.getHosts(), diff));
            }
            DiskCache.write(serviceInfo, this.cacheDir);
        }
        return serviceInfo;
    }

    private boolean isEmptyOrErrorPush(ServiceInfo serviceInfo) {
        return null == serviceInfo.getHosts() || this.pushEmptyProtection && !serviceInfo.validate();
    }

    private InstancesDiff getServiceInfoDiff(ServiceInfo oldService, ServiceInfo newService) {
        return this.instancesDiffer.doDiff(oldService, newService);
    }

    public String getCacheDir() {
        return this.cacheDir;
    }

    public boolean isFailoverSwitch() {
        return this.failoverReactor.isFailoverSwitch();
    }

    public ServiceInfo getFailoverServiceInfo(String serviceName, String groupName) {
        String key = NamingUtils.getGroupedName(serviceName, groupName);
        return this.failoverReactor.getService(key);
    }

    @Override
    public void shutdown() throws NacosException {
        String className = this.getClass().getName();
        LogUtils.NAMING_LOGGER.info("{} do shutdown begin", (Object)className);
        this.failoverReactor.shutdown();
        LogUtils.NAMING_LOGGER.info("{} do shutdown stop", (Object)className);
    }
}

