/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.labels.impl;

import com.alibaba.nacos.common.labels.LabelsCollector;
import com.alibaba.nacos.common.labels.LabelsCollectorManager;
import com.alibaba.nacos.common.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLabelsCollectorManager
implements LabelsCollectorManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"com.alibaba.nacos.common.labels");
    private ArrayList<LabelsCollector> labelsCollectorsList = this.loadLabelsCollectors();
    private static char[] validChars = new char[]{'_', '-', '.'};
    private static int maxLength = 128;

    @Override
    public Map<String, String> getLabels(Properties properties) {
        LOGGER.info("DefaultLabelsCollectorManager get labels.....");
        Map<String, String> labels = this.getLabels(this.labelsCollectorsList, properties);
        LOGGER.info("DefaultLabelsCollectorManager get labels finished,labels :{}", labels);
        return labels;
    }

    Map<String, String> getLabels(ArrayList<LabelsCollector> labelsCollectorsList, Properties properties) {
        if (properties == null) {
            properties = new Properties();
        }
        HashMap<String, String> labels = new HashMap<String, String>(8);
        for (LabelsCollector labelsCollector : labelsCollectorsList) {
            LOGGER.info("Process LabelsCollector with [name:{}]", (Object)labelsCollector.getName());
            for (Map.Entry<String, String> entry : labelsCollector.collectLabels(properties).entrySet()) {
                if (!this.checkValidLabel(entry.getKey(), entry.getValue())) {
                    LOGGER.info(" ignore invalid label with [key:{}, value:{}] of collector [name:{}]", new Object[]{entry.getKey(), entry.getValue(), labelsCollector.getName()});
                    continue;
                }
                if (this.innerAddLabel(labels, entry.getKey(), entry.getValue())) {
                    LOGGER.info("pick label with [key:{}, value:{}] of collector [name:{}]", new Object[]{entry.getKey(), entry.getValue(), labelsCollector.getName()});
                    continue;
                }
                LOGGER.info(" ignore label with [key:{}, value:{}] of collector [name:{}],already existed in LabelsCollectorManager with previous [value:{}]\uff0c", new Object[]{entry.getKey(), entry.getValue(), labelsCollector.getName(), labels.get(entry.getKey())});
            }
        }
        return labels;
    }

    private boolean checkValidLabel(String key, String value) {
        return DefaultLabelsCollectorManager.isValid(key) && DefaultLabelsCollectorManager.isValid(value);
    }

    private static boolean isValid(String param) {
        if (StringUtils.isBlank(param)) {
            return false;
        }
        int length = param.length();
        if (length > maxLength) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            char ch = param.charAt(i);
            if (Character.isLetterOrDigit(ch) || DefaultLabelsCollectorManager.isValidChar(ch)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidChar(char ch) {
        for (char c : validChars) {
            if (c != ch) continue;
            return true;
        }
        return false;
    }

    private ArrayList<LabelsCollector> loadLabelsCollectors() {
        ServiceLoader<LabelsCollector> labelsCollectors = ServiceLoader.load(LabelsCollector.class);
        ArrayList<LabelsCollector> labelsCollectorsList = new ArrayList<LabelsCollector>();
        for (LabelsCollector labelsCollector : labelsCollectors) {
            labelsCollectorsList.add(labelsCollector);
        }
        labelsCollectorsList.sort((o1, o2) -> o2.getOrder() - o1.getOrder());
        return labelsCollectorsList;
    }

    private boolean innerAddLabel(Map<String, String> labels, String key, String value) {
        return null == labels.putIfAbsent(key, value);
    }
}

