/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.mqtt.server.network;

import com.alibaba.mqtt.server.config.ChannelConfig;
import com.alibaba.mqtt.server.util.AliyunCredentialsProvider;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.impl.CredentialsProvider;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.TimeoutException;

public class AbstractChannel {
    private ConnectionFactory factory = new ConnectionFactory();
    private ChannelConfig channelConfig;
    private Connection connection;
    protected Channel channel;

    public AbstractChannel(ChannelConfig channelConfig) {
        this.channelConfig = channelConfig;
    }

    public Channel getChannel() {
        return this.channel;
    }

    protected void start() throws IOException, TimeoutException {
        long ts = System.currentTimeMillis();
        this.factory.setHost(this.channelConfig.getDomain());
        this.factory.setCredentialsProvider((CredentialsProvider)new AliyunCredentialsProvider(this.channelConfig.getAccessKey(), this.channelConfig.getSecretKey(), this.channelConfig.getInstanceId(), ts));
        this.factory.setAutomaticRecoveryEnabled(true);
        this.factory.setNetworkRecoveryInterval(this.channelConfig.getNetworkRecoveryInterval());
        this.factory.setPort(this.channelConfig.getPort());
        this.factory.setVirtualHost("MQTT");
        this.factory.setConnectionTimeout(this.channelConfig.getConnectionTimeout());
        this.factory.setHandshakeTimeout(this.channelConfig.getHandshakeTimeout());
        this.factory.setRequestedHeartbeat(this.channelConfig.getRequestedHeartbeat());
        this.factory.setShutdownTimeout(this.channelConfig.getShutdownTimeout());
        HashMap<String, String> properties = new HashMap<String, String>(1);
        properties.put("signKey", String.valueOf(ts));
        this.factory.setClientProperties(properties);
        this.connection = this.factory.newConnection();
        this.channel = this.connection.createChannel();
    }

    protected void stop() throws IOException {
        this.connection.close();
    }
}

