/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.mqtt.server.model;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.mqtt.server.model.StatusType;
import java.nio.charset.StandardCharsets;

public class StatusNotice {
    private String clientId;
    private StatusType statusType;
    private String channelId;
    private String clientIp;
    private long time;

    public StatusNotice(byte[] payload) {
        JSONObject msgBody = JSON.parseObject((String)new String(payload, StandardCharsets.UTF_8));
        String eventType = msgBody.getString("eventType");
        this.statusType = "connect".equals(eventType) ? StatusType.ONLINE : StatusType.OFFLINE;
        this.clientId = msgBody.getString("clientId");
        this.channelId = msgBody.getString("channelId");
        this.clientIp = msgBody.getString("clientIp");
        this.time = msgBody.getLongValue("time");
    }

    public String getClientId() {
        return this.clientId;
    }

    public StatusType getStatusType() {
        return this.statusType;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public long getTime() {
        return this.time;
    }
}

