/*
 * Decompiled with CFR 0.152.
 */
package io.termd.core.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.termd.core.function.BiConsumer;
import io.termd.core.function.Consumer;
import io.termd.core.io.BinaryDecoder;
import io.termd.core.io.BinaryEncoder;
import io.termd.core.tty.TtyConnectionSupport;
import io.termd.core.tty.TtyEvent;
import io.termd.core.tty.TtyEventDecoder;
import io.termd.core.tty.TtyOutputMode;
import io.termd.core.util.Vector;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;

public abstract class HttpTtyConnection
extends TtyConnectionSupport {
    public static final Vector DEFAULT_SIZE = new Vector(80, 24);
    private Charset charset;
    private Vector size;
    private Consumer<Vector> sizeHandler;
    private final TtyEventDecoder eventDecoder;
    private final BinaryDecoder decoder;
    private final Consumer<int[]> stdout;
    private Consumer<Void> closeHandler;
    private Consumer<String> termHandler;
    private long lastAccessedTime = System.currentTimeMillis();

    public HttpTtyConnection() {
        this(Charset.forName("UTF-8"), DEFAULT_SIZE);
    }

    public HttpTtyConnection(Charset charset, Vector size) {
        this.charset = charset;
        this.size = size;
        this.eventDecoder = new TtyEventDecoder(3, 26, 4);
        this.decoder = new BinaryDecoder(512, charset, this.eventDecoder);
        this.stdout = new TtyOutputMode(new BinaryEncoder(charset, new Consumer<byte[]>(){

            @Override
            public void accept(byte[] bytes) {
                HttpTtyConnection.this.write(bytes);
            }
        }));
    }

    @Override
    public Charset outputCharset() {
        return this.charset;
    }

    @Override
    public Charset inputCharset() {
        return this.charset;
    }

    @Override
    public long lastAccessedTime() {
        return this.lastAccessedTime;
    }

    @Override
    public String terminalType() {
        return "vt100";
    }

    protected abstract void write(byte[] var1);

    public void writeToDecoder(byte[] bytes) {
        this.lastAccessedTime = System.currentTimeMillis();
        this.decoder.write(bytes);
    }

    public void writeToDecoder(String msg) {
        String action;
        Map obj;
        ObjectMapper mapper = new ObjectMapper();
        try {
            obj = (Map)mapper.readValue(msg, Map.class);
            action = (String)obj.get("action");
        }
        catch (IOException e) {
            return;
        }
        if ("read".equals(action)) {
            this.lastAccessedTime = System.currentTimeMillis();
            String data = (String)obj.get("data");
            this.decoder.write(data.getBytes());
        } else if ("resize".equals(action)) {
            try {
                Vector newSize;
                int cols = (Integer)HttpTtyConnection.getOrDefault(obj, "cols", this.size.x());
                int rows = (Integer)HttpTtyConnection.getOrDefault(obj, "rows", this.size.y());
                if (cols > 0 && rows > 0 && !(newSize = new Vector(cols, rows)).equals(this.size())) {
                    this.size = newSize;
                    if (this.sizeHandler != null) {
                        this.sizeHandler.accept(this.size);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static Object getOrDefault(Map<String, Object> map, String key, Object defaultValue) {
        return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    @Override
    public Consumer<String> getTerminalTypeHandler() {
        return this.termHandler;
    }

    @Override
    public void setTerminalTypeHandler(Consumer<String> handler) {
        this.termHandler = handler;
    }

    @Override
    public Vector size() {
        return this.size;
    }

    @Override
    public Consumer<Vector> getSizeHandler() {
        return this.sizeHandler;
    }

    @Override
    public void setSizeHandler(Consumer<Vector> handler) {
        this.sizeHandler = handler;
    }

    @Override
    public BiConsumer<TtyEvent, Integer> getEventHandler() {
        return this.eventDecoder.getEventHandler();
    }

    @Override
    public void setEventHandler(BiConsumer<TtyEvent, Integer> handler) {
        this.eventDecoder.setEventHandler(handler);
    }

    @Override
    public Consumer<int[]> getStdinHandler() {
        return this.eventDecoder.getReadHandler();
    }

    @Override
    public void setStdinHandler(Consumer<int[]> handler) {
        this.eventDecoder.setReadHandler(handler);
    }

    @Override
    public Consumer<int[]> stdoutHandler() {
        return this.stdout;
    }

    @Override
    public void setCloseHandler(Consumer<Void> closeHandler) {
        this.closeHandler = closeHandler;
    }

    @Override
    public Consumer<Void> getCloseHandler() {
        return this.closeHandler;
    }
}

