/*
 * Decompiled with CFR 0.152.
 */
package io.termd.core.readline.functions;

import io.termd.core.readline.Function;
import io.termd.core.readline.LineBuffer;
import io.termd.core.readline.Readline;
import io.termd.core.util.LineBufferUtils;
import java.util.List;

public class HistorySearchBackward
implements Function {
    @Override
    public String name() {
        return "history-search-backward";
    }

    @Override
    public void apply(Readline.Interaction interaction) {
        int searchStart;
        LineBuffer buf = interaction.buffer().copy();
        int cursor = buf.getCursor();
        List<int[]> history = interaction.history();
        int curr = interaction.getHistoryIndex();
        for (int i = searchStart = curr + 1; i < history.size(); ++i) {
            int[] line = history.get(i);
            if (LineBufferUtils.equals(buf, line) || !LineBufferUtils.matchBeforeCursor(buf, line)) continue;
            interaction.refresh(new LineBuffer().insert(line).setCursor(cursor));
            interaction.setHistoryIndex(i);
            break;
        }
        interaction.resume();
    }
}

