/*
 * Decompiled with CFR 0.152.
 */
package io.termd.core.readline;

import io.termd.core.function.IntConsumer;
import java.util.LinkedList;

public class LineStatus
implements IntConsumer {
    protected int quote = 0;
    protected Transition transition;

    public boolean isEscaped() {
        return this.transition == Transition.FROM_ESC;
    }

    public boolean isEscaping() {
        return this.transition == Transition.TO_ESC;
    }

    public boolean isQuoted() {
        return this.quote != 0;
    }

    public boolean isWeaklyQuoted() {
        return this.quote == 34;
    }

    public boolean isStronglyQuoted() {
        return this.quote == 39;
    }

    public int getQuote() {
        return this.quote;
    }

    public boolean isCodePoint() {
        return this.transition == Transition.CODE_POINT || this.transition == Transition.FROM_ESC;
    }

    @Override
    public void accept(int cp) {
        Transition next;
        if (this.transition == Transition.TO_ESC) {
            next = Transition.FROM_ESC;
        } else {
            block0 : switch (this.quote) {
                case 0: {
                    switch (cp) {
                        case 39: {
                            this.quote = 39;
                            next = Transition.TO_STRONG;
                            break block0;
                        }
                        case 34: {
                            this.quote = 34;
                            next = Transition.TO_WEAK;
                            break block0;
                        }
                        case 92: {
                            next = Transition.TO_ESC;
                            break block0;
                        }
                    }
                    next = Transition.CODE_POINT;
                    break;
                }
                case 39: {
                    if (cp == 39) {
                        this.quote = 0;
                        next = Transition.FROM_STRONG;
                        break;
                    }
                    next = Transition.CODE_POINT;
                    break;
                }
                case 34: {
                    if (cp == 34) {
                        this.quote = 0;
                        next = Transition.FROM_WEAK;
                        break;
                    }
                    if (cp == 92) {
                        next = Transition.TO_ESC;
                        break;
                    }
                    next = Transition.CODE_POINT;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        this.transition = next;
    }

    private static enum Transition {
        TO_STRONG,
        TO_WEAK,
        FROM_STRONG,
        FROM_WEAK,
        TO_ESC,
        CODE_POINT,
        FROM_ESC;

    }

    static class Ext
    extends LineStatus
    implements IntConsumer {
        final LinkedList<Integer> buffer = new LinkedList();

        Ext() {
        }

        @Override
        public void accept(int codePoint) {
            super.accept(codePoint);
            switch (this.transition) {
                case TO_WEAK: {
                    this.buffer.add(34);
                    break;
                }
                case TO_STRONG: {
                    this.buffer.add(39);
                    break;
                }
                case FROM_WEAK: {
                    this.buffer.add(34);
                    break;
                }
                case FROM_STRONG: {
                    this.buffer.add(39);
                    break;
                }
                case TO_ESC: {
                    this.buffer.add(92);
                    break;
                }
                case FROM_ESC: {
                    if (codePoint != 13) {
                        this.buffer.add(codePoint);
                        break;
                    }
                    this.buffer.removeLast();
                    break;
                }
                case CODE_POINT: {
                    this.buffer.add(codePoint);
                }
            }
        }
    }
}

