/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.metrics.rest.server.jersey;

import com.alibaba.metrics.rest.server.NamedThreadFactory;
import com.alibaba.metrics.rest.server.jersey.HttpHandlerContainer;
import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.Application;
import org.glassfish.jersey.jdkhttp.internal.LocalizationMessages;
import org.glassfish.jersey.server.ContainerFactory;
import org.glassfish.jersey.server.ResourceConfig;

public class HttpServerFactory {
    private HttpServerFactory() {
    }

    public static HttpServer createHttpServer(URI uri, String bindingHost, int corePoolSize, int maxPoolSize, long keepAliveTime, int maxQueueSize, ResourceConfig configuration) throws ProcessingException {
        HttpHandlerContainer handler = (HttpHandlerContainer)ContainerFactory.createContainer(HttpHandlerContainer.class, (Application)configuration);
        return HttpServerFactory.createHttpServer(uri, bindingHost, handler, corePoolSize, maxPoolSize, keepAliveTime, maxQueueSize);
    }

    private static HttpServer createHttpServer(URI uri, String bindingHost, final HttpHandlerContainer handler, int corePoolSize, int maxPoolSize, long keepAliveTime, int maxQueueSize) throws ProcessingException {
        HttpServer server;
        if (uri == null) {
            throw new IllegalArgumentException(LocalizationMessages.ERROR_CONTAINER_URI_NULL());
        }
        String scheme = uri.getScheme();
        if (!scheme.equalsIgnoreCase("http") && !scheme.equalsIgnoreCase("https")) {
            throw new IllegalArgumentException(LocalizationMessages.ERROR_CONTAINER_URI_SCHEME_UNKNOWN((Object)uri));
        }
        String path = uri.getPath();
        if (path == null) {
            throw new IllegalArgumentException(LocalizationMessages.ERROR_CONTAINER_URI_PATH_NULL((Object)uri));
        }
        if (path.length() == 0) {
            throw new IllegalArgumentException(LocalizationMessages.ERROR_CONTAINER_URI_PATH_EMPTY((Object)uri));
        }
        if (path.charAt(0) != '/') {
            throw new IllegalArgumentException(LocalizationMessages.ERROR_CONTAINER_URI_PATH_START((Object)uri));
        }
        int port = uri.getPort() == -1 ? 80 : uri.getPort();
        try {
            server = scheme.equalsIgnoreCase("http") ? HttpServer.create(new InetSocketAddress(bindingHost, port), 0) : HttpsServer.create(new InetSocketAddress(bindingHost, port), 0);
        }
        catch (IOException ioe) {
            throw new ProcessingException(LocalizationMessages.ERROR_CONTAINER_EXCEPTION_IO(), (Throwable)ioe);
        }
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(corePoolSize, maxPoolSize, keepAliveTime, TimeUnit.MILLISECONDS, new LinkedBlockingDeque<Runnable>(maxQueueSize), new NamedThreadFactory("metrics-pool"));
        server.setExecutor(threadPoolExecutor);
        server.createContext(path, handler);
        HttpServer wrapper = new HttpServer(){

            @Override
            public void bind(InetSocketAddress inetSocketAddress, int i) throws IOException {
                server.bind(inetSocketAddress, i);
            }

            @Override
            public void start() {
                server.start();
                handler.onServerStart();
            }

            @Override
            public void setExecutor(Executor executor) {
                server.setExecutor(executor);
            }

            @Override
            public Executor getExecutor() {
                return server.getExecutor();
            }

            @Override
            public void stop(int i) {
                handler.onServerStop();
                server.stop(i);
            }

            @Override
            public HttpContext createContext(String s, HttpHandler httpHandler) {
                return server.createContext(s, httpHandler);
            }

            @Override
            public HttpContext createContext(String s) {
                return server.createContext(s);
            }

            @Override
            public void removeContext(String s) throws IllegalArgumentException {
                server.removeContext(s);
            }

            @Override
            public void removeContext(HttpContext httpContext) {
                server.removeContext(httpContext);
            }

            @Override
            public InetSocketAddress getAddress() {
                return server.getAddress();
            }
        };
        wrapper.start();
        return wrapper;
    }
}

