/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.metrics.rest.server.jersey;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.serializer.AfterFilter;
import com.alibaba.fastjson.serializer.BeforeFilter;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.NameFilter;
import com.alibaba.fastjson.serializer.PropertyFilter;
import com.alibaba.fastjson.serializer.PropertyPreFilter;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.ValueFilter;
import com.alibaba.metrics.rest.server.jersey.FastJsonConfig;
import com.alibaba.metrics.rest.server.jersey.FastJsonType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;

@Provider
public class FastJsonProvider
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    private boolean annotated = false;
    private String[] scanpackages = null;
    private Class<?>[] clazzes = null;
    @Context
    UriInfo uriInfo;
    private FastJsonConfig fastJsonConfig = new FastJsonConfig(new SerializeConfig(), new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});

    public FastJsonProvider() {
    }

    public FastJsonProvider(boolean annotated) {
        this.annotated = annotated;
    }

    public FastJsonProvider(String[] scanpackages) {
        this.scanpackages = scanpackages;
    }

    public FastJsonProvider(String[] scanpackages, boolean annotated) {
        this.scanpackages = scanpackages;
        this.annotated = annotated;
    }

    public FastJsonProvider(Class<?>[] clazzes) {
        this.clazzes = clazzes;
    }

    public FastJsonProvider init(FastJsonConfig fastJsonConfig) {
        this.fastJsonConfig = fastJsonConfig;
        return this;
    }

    protected boolean isValidType(Class<?> type, Annotation[] classAnnotations) {
        if (type == null) {
            return false;
        }
        if (this.annotated) {
            return this.checkAnnotation(type);
        }
        if (this.scanpackages != null) {
            String classPackage = type.getPackage().getName();
            for (String pkg : this.scanpackages) {
                if (!classPackage.startsWith(pkg)) continue;
                return this.checkAnnotation(type);
            }
            return false;
        }
        if (this.clazzes != null) {
            for (Class<?> cls : this.clazzes) {
                if (cls != type) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean checkAnnotation(Class<?> type) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = type.getAnnotations()) {
            if (!(annotation instanceof FastJsonType)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasMatchingMediaType(MediaType mediaType) {
        if (mediaType != null) {
            String subtype = mediaType.getSubtype();
            return "json".equalsIgnoreCase(subtype) || subtype.endsWith("+json") || "javascript".equalsIgnoreCase(subtype) || "x-javascript".equalsIgnoreCase(subtype);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toJSONString(Object object, SerializeFilter filter, SerializerFeature[] features) {
        SerializeWriter out = new SerializeWriter();
        try {
            JSONSerializer serializer = new JSONSerializer(out, this.fastJsonConfig.serializeConfig);
            if (features != null) {
                for (SerializerFeature feature : features) {
                    serializer.config(feature, true);
                }
            }
            if (filter != null) {
                if (filter instanceof PropertyPreFilter) {
                    serializer.getPropertyPreFilters().add((PropertyPreFilter)filter);
                }
                if (filter instanceof NameFilter) {
                    serializer.getNameFilters().add((NameFilter)filter);
                }
                if (filter instanceof ValueFilter) {
                    serializer.getValueFilters().add((ValueFilter)filter);
                }
                if (filter instanceof PropertyFilter) {
                    serializer.getPropertyFilters().add((PropertyFilter)filter);
                }
                if (filter instanceof BeforeFilter) {
                    serializer.getBeforeFilters().add((BeforeFilter)filter);
                }
                if (filter instanceof AfterFilter) {
                    serializer.getAfterFilters().add((AfterFilter)filter);
                }
            }
            serializer.write(object);
            String string = out.toString();
            return string;
        }
        finally {
            out.close();
        }
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (!this.hasMatchingMediaType(mediaType)) {
            return false;
        }
        return this.isValidType(type, annotations);
    }

    public long getSize(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        String jsonStr;
        List prettyList;
        SerializeFilter filter = null;
        if (this.uriInfo != null && (prettyList = (List)this.uriInfo.getQueryParameters().get((Object)"pretty")) != null && !prettyList.isEmpty() && !((String)prettyList.get(0)).equalsIgnoreCase("false")) {
            if (this.fastJsonConfig.serializerFeatures == null) {
                this.fastJsonConfig.serializerFeatures = new SerializerFeature[]{SerializerFeature.PrettyFormat};
            } else {
                List<SerializerFeature> serializerFeatures = Arrays.asList(this.fastJsonConfig.serializerFeatures);
                serializerFeatures.add(SerializerFeature.PrettyFormat);
                this.fastJsonConfig.serializerFeatures = serializerFeatures.toArray(new SerializerFeature[0]);
            }
        }
        if (this.fastJsonConfig.serializeFilters != null) {
            filter = this.fastJsonConfig.serializeFilters.get(type);
        }
        if ((jsonStr = this.toJSONString(t, filter, this.fastJsonConfig.serializerFeatures)) != null) {
            entityStream.write(jsonStr.getBytes("UTF-8"));
        }
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (!this.hasMatchingMediaType(mediaType)) {
            return false;
        }
        return this.isValidType(type, annotations);
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        String input = null;
        try {
            input = FastJsonProvider.inputStreamToString(entityStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (input == null) {
            return null;
        }
        if (this.fastJsonConfig.features == null) {
            return JSON.parseObject((String)input, type, (ParserConfig)this.fastJsonConfig.parserConfig, (int)JSON.DEFAULT_PARSER_FEATURE, (Feature[])new Feature[0]);
        }
        return JSON.parseObject((String)input, type, (ParserConfig)this.fastJsonConfig.parserConfig, (int)JSON.DEFAULT_PARSER_FEATURE, (Feature[])this.fastJsonConfig.features);
    }

    private static String inputStreamToString(InputStream in) throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        StringBuilder buffer = new StringBuilder();
        String line = "";
        while ((line = br.readLine()) != null) {
            buffer.append(line);
        }
        return buffer.toString();
    }
}

