/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.metrics.rest.server;

import com.alibaba.metrics.rest.MetricsController;
import com.alibaba.metrics.rest.MetricsResource;
import com.alibaba.metrics.rest.server.jersey.FastJsonFeature;
import com.alibaba.metrics.rest.server.jersey.HttpServerFactory;
import com.alibaba.metrics.rest.server.jersey.JerseyEventListener;
import com.sun.net.httpserver.HttpServer;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.jersey.logging.LoggingFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.TracingConfig;

public class MetricsHttpServer {
    private static final int DEFAULT_PORT = 8006;
    private static final int DEFAULT_CORE_POOL_SIZE = 10;
    private static final int DEFAULT_MAX_POOL_SIZE = 100;
    private static final long DEFAULT_MAX_ALIVE_TIMEOUT = 0L;
    private static final int DEFAULT_MAX_QUEUE_SIZE = 5000;
    private static final String DEFAULT_BINDING_HOST = "0.0.0.0";
    private static final String ALI_METRICS_BINDING_HOST = "com.alibaba.metrics.http.binding.host";
    private static final String ALI_METRICS_HTTP_PORT = "com.alibaba.metrics.http.port";
    private int port;
    private final int corePoolSize;
    private final int maxPoolSize;
    private final long keepAliveTimeout;
    private final int maxQueueSize;
    private HttpServer httpServer;
    private ResourceConfig resourceConfig = new ResourceConfig();

    public MetricsHttpServer() {
        this.port = Integer.getInteger(ALI_METRICS_HTTP_PORT, 8006);
        this.corePoolSize = 10;
        this.maxPoolSize = 100;
        this.keepAliveTimeout = 0L;
        this.maxQueueSize = 5000;
    }

    public MetricsHttpServer(int port, int corePoolSize, int maxPoolSize, long keepAliveTimeout, int maxQueueSize) {
        this.port = port;
        this.corePoolSize = corePoolSize;
        this.maxPoolSize = maxPoolSize;
        this.keepAliveTimeout = keepAliveTimeout;
        this.maxQueueSize = maxQueueSize;
    }

    public void start() {
        URI baseUri = UriBuilder.fromUri((String)"http://localhost/").port(this.getPort()).build(new Object[0]);
        Logger jerseyLogger = Logger.getLogger("org.glassfish.jersey");
        jerseyLogger.setLevel(Level.WARNING);
        this.resourceConfig.register(MetricsResource.class).register(MetricsController.class).property("jersey.config.server.tracing.type", (Object)TracingConfig.ON_DEMAND.name()).register((Object)new LoggingFeature(jerseyLogger)).register(JerseyEventListener.class).register(FastJsonFeature.class);
        String bindingHost = System.getProperty(ALI_METRICS_BINDING_HOST, DEFAULT_BINDING_HOST);
        if (System.getProperty("sun.net.httpserver.maxReqTime") == null) {
            System.setProperty("sun.net.httpserver.maxReqTime", "30");
        }
        if (System.getProperty("sun.net.httpserver.maxRspTime") == null) {
            System.setProperty("sun.net.httpserver.maxRspTime", "30");
        }
        try {
            Class<?> fastJsonAutoDiscoverClass = MetricsHttpServer.class.getClassLoader().loadClass("com.alibaba.fastjson.support.jaxrs.FastJsonAutoDiscoverable");
            Field autoDscoverField = fastJsonAutoDiscoverClass.getField("autoDiscover");
            autoDscoverField.set(null, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.httpServer = HttpServerFactory.createHttpServer(baseUri, bindingHost, this.corePoolSize, this.maxPoolSize, this.keepAliveTimeout, this.maxQueueSize, this.resourceConfig);
    }

    public void stop() {
        if (this.httpServer != null) {
            this.httpServer.stop(0);
        }
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public ResourceConfig getResourceConfig() {
        return this.resourceConfig;
    }

    public void setResourceConfig(ResourceConfig resourceConfig) {
        this.resourceConfig = resourceConfig;
    }
}

