/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.metrics.rest;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.metrics.ClusterHistogram;
import com.alibaba.metrics.Compass;
import com.alibaba.metrics.Counter;
import com.alibaba.metrics.FastCompass;
import com.alibaba.metrics.Gauge;
import com.alibaba.metrics.Histogram;
import com.alibaba.metrics.IMetricManager;
import com.alibaba.metrics.Meter;
import com.alibaba.metrics.MetricFilter;
import com.alibaba.metrics.MetricLevel;
import com.alibaba.metrics.MetricManager;
import com.alibaba.metrics.MetricName;
import com.alibaba.metrics.MetricRegistry;
import com.alibaba.metrics.ReservoirType;
import com.alibaba.metrics.Timer;
import com.alibaba.metrics.common.CollectLevel;
import com.alibaba.metrics.common.MetricObject;
import com.alibaba.metrics.common.MetricsCollector;
import com.alibaba.metrics.common.MetricsCollectorFactory;
import com.alibaba.metrics.common.filter.MetricNameSetFilter;
import com.alibaba.metrics.rest.MetricLevelFilter;
import com.alibaba.metrics.rest.MetricObjectPropertyFilter;
import com.alibaba.metrics.rest.Utils;
import com.alibaba.metrics.server.MetricsSearchService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/metrics")
public class MetricsResource {
    private static final Logger logger = LoggerFactory.getLogger(MetricsResource.class);
    private static IMetricManager manager = MetricManager.getIMetricManager();
    private static final double rateFactor = TimeUnit.SECONDS.toSeconds(1L);
    private static final double durationFactor = 1.0 / (double)TimeUnit.MILLISECONDS.toNanos(1L);
    private static final String MULTI_GROUP_DELIM = ",";
    private static final MetricName baseName = new MetricName("middleware.metrics.rest.url");
    private static final MetricObjectPropertyFilter filter = new MetricObjectPropertyFilter();

    @Path(value="/list")
    @GET
    @Produces(value={"application/json;qs=0.1", "text/html"})
    public Response listMetrics() {
        if (manager.isEnabled()) {
            LinkedHashMap metrics = new LinkedHashMap();
            for (String groupName : manager.listMetricGroups()) {
                MetricRegistry registry = manager.getMetricRegistryByGroup(groupName);
                LinkedHashSet<MetricObject> metricsPerRegistry = new LinkedHashSet<MetricObject>();
                metricsPerRegistry.addAll(this.buildMetricRegistry(registry));
                metrics.put(groupName, metricsPerRegistry);
            }
            try {
                String data = JSON.toJSONString(Utils.buildResultPojo(metrics, true, ""), (SerializeFilter)filter, (SerializerFeature[])new SerializerFeature[0]);
                return Response.ok((Object)data).build();
            }
            catch (Exception e) {
                return Utils.buildResult(null, false, e.toString());
            }
        }
        return Utils.buildResult(null, false, "Metrics has been disabled explicitly!");
    }

    @GET
    @Produces(value={"application/json;qs=0.1", "text/html"})
    public Response getMetrics() {
        return this.getMetrics("all");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/json;qs=0.1", "text/html"})
    @Path(value="/{group}")
    public Response getMetrics(@DefaultValue(value="all") @PathParam(value="group") String group) {
        MetricName name = baseName.tagged(new String[]{"url", "/" + group}).level(MetricLevel.TRIVIAL);
        Timer urlTimer = manager.getTimer("metrics", name, ReservoirType.BUCKET);
        Timer.Context context = urlTimer.time();
        try {
            if (!manager.isEnabled()) {
                Response response = Utils.buildResult(null, false, "Metrics has been disabled explicitly!");
                return response;
            }
            TreeMap<String, List<MetricObject>> metricsData = new TreeMap<String, List<MetricObject>>();
            if ("all".equalsIgnoreCase(group) || group == null) {
                for (String groupName : manager.listMetricGroups()) {
                    try {
                        MetricRegistry registry = manager.getMetricRegistryByGroup(groupName);
                        metricsData.put(groupName, this.buildMetricRegistry(registry));
                    }
                    catch (Throwable e) {
                        Response response = Utils.buildResult(null, false, e.toString());
                        context.stop();
                        return response;
                    }
                }
                Response response = Utils.buildResult(metricsData, true, "");
                return response;
            }
            if (group.contains(MULTI_GROUP_DELIM)) {
                Response groups;
                for (String groupName : groups = group.split(MULTI_GROUP_DELIM)) {
                    try {
                        if (!manager.listMetricGroups().contains(groupName)) continue;
                        MetricRegistry registry = manager.getMetricRegistryByGroup(groupName);
                        metricsData.put(groupName, this.buildMetricRegistry(registry));
                    }
                    catch (Throwable e) {
                        Response response = Utils.buildResult(null, false, e.toString());
                        context.stop();
                        return response;
                    }
                }
                Response groupName = Utils.buildResult(metricsData, true, "");
                return groupName;
            }
            List groups = manager.listMetricGroups();
            if (!groups.contains(group)) {
                Response groupName = Utils.buildResult(null, false, "The specified group is not found!");
                return groupName;
            }
            MetricRegistry registry = manager.getMetricRegistryByGroup(group);
            Response response = Utils.buildResult(this.buildMetricRegistry(registry), true, "");
            return response;
        }
        finally {
            context.stop();
        }
    }

    @GET
    @Produces(value={"application/json;qs=0.1", "text/html"})
    @Path(value="/{group}/level/{level}")
    public Response getMetricByLevel(@PathParam(value="group") String group, @PathParam(value="level") String level, @QueryParam(value="above") boolean above) {
        if (!manager.isEnabled()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        if (group.contains(MULTI_GROUP_DELIM)) {
            TreeMap<String, List<MetricObject>> metricsData = new TreeMap<String, List<MetricObject>>();
            String[] groups = group.split(MULTI_GROUP_DELIM);
            String[] levels = level.split(MULTI_GROUP_DELIM);
            for (int i = 0; i < groups.length; ++i) {
                try {
                    if (!manager.listMetricGroups().contains(groups[i])) continue;
                    MetricRegistry registry = manager.getMetricRegistryByGroup(groups[i]);
                    MetricLevelFilter levelFilter = new MetricLevelFilter(MetricLevel.valueOf((String)levels[i]), above);
                    metricsData.put(groups[i], this.buildMetricRegistry(registry, levelFilter));
                    continue;
                }
                catch (Throwable e) {
                    return Utils.buildResult(null, false, e.toString());
                }
            }
            return Utils.buildResult(metricsData, true, "");
        }
        List groups = manager.listMetricGroups();
        if (!groups.contains(group)) {
            return Utils.buildResult(null, false, "The specified group is not found!");
        }
        MetricRegistry registry = manager.getMetricRegistryByGroup(group);
        try {
            MetricLevelFilter levelFilter = new MetricLevelFilter(MetricLevel.valueOf((String)level), above);
            List<MetricObject> metricObjects = this.buildMetricRegistry(registry, levelFilter);
            if (metricObjects.isEmpty()) {
                return Utils.buildResult(null, false, "No metric matching the specified level found!");
            }
            return Utils.buildResult(metricObjects);
        }
        catch (IllegalArgumentException e) {
            return Utils.buildResult(null, false, e.toString());
        }
    }

    @GET
    @Produces(value={"application/json;qs=0.1", "text/html"})
    @Path(value="/{group}/{metric}")
    public Response getMetric(@PathParam(value="group") String group, @PathParam(value="metric") String metricName, @QueryParam(value="tagKey") List<String> tagKeys, @QueryParam(value="tagValue") List<String> tagValues) {
        if (!manager.isEnabled()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        List groups = manager.listMetricGroups();
        if (!groups.contains(group)) {
            return Utils.buildResult(null, false, "The specified group is not found!");
        }
        MetricRegistry registry = manager.getMetricRegistryByGroup(group);
        List<MetricObject> metricObjects = this.buildMetricRegistry(registry, (MetricFilter)new MetricNameSetFilter(new String[]{metricName}));
        if (metricObjects.isEmpty()) {
            return Utils.buildResult(null, false, "The specified metric is not found!");
        }
        return Utils.buildResult(metricObjects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/json;qs=0.1", "text/html"})
    @Path(value="/specific")
    public Response getMetric(@QueryParam(value="metric") Set<String> metricNames, @QueryParam(value="zeroIgnore") boolean zeroIgnore) {
        if (!manager.isEnabled()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        MetricName name = baseName.tagged(new String[]{"url", "/specific"}).level(MetricLevel.TRIVIAL);
        Timer urlTimer = manager.getTimer("metrics", name, ReservoirType.BUCKET);
        Timer.Context context = urlTimer.time();
        try {
            Response response = this.getMetricsInternal(metricNames, zeroIgnore);
            return response;
        }
        finally {
            context.stop();
        }
    }

    @POST
    @Produces(value={"application/json;qs=0.1", "text/html"})
    @Path(value="/specific")
    public Response getMetricsByPost(MultivaluedMap<String, String> params, @QueryParam(value="zeroIgnore") boolean zeroIgnore) {
        HashSet<String> metricNames = new HashSet<String>((Collection)params.get((Object)"metric"));
        return this.getMetric(metricNames, zeroIgnore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;qs=0.1", "text/html"})
    @Path(value="/search")
    public Response searchMetrics(String metricsSearch, @HeaderParam(value="REMOTE_ADDR") String remoteAddr, @HeaderParam(value="X-Forwarded-For") String xForwardedFor, @Context HttpServletRequest httpServletRequest) {
        if (httpServletRequest != null) {
            logger.info("httpheader REMOTE_ADDR {}, httpheader X-Forwarded-For {};socket remoteaddr {}, port {}", new Object[]{remoteAddr, xForwardedFor, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemotePort()});
        } else {
            logger.info("httpheader REMOTE_ADDR {}, httpheader X-Forwarded-For {}\uff0chttpServletRequest is null", (Object)remoteAddr, (Object)xForwardedFor);
        }
        if (!manager.isEnabled()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        MetricName name = baseName.tagged(new String[]{"url", "/search"}).level(MetricLevel.TRIVIAL);
        Timer urlTimer = manager.getTimer("metrics", name, ReservoirType.BUCKET);
        Timer.Context context = urlTimer.time();
        try {
            MetricsSearchService service = MetricsSearchService.getInstance();
            Response response = Response.ok((Object)service.search(metricsSearch)).build();
            return response;
        }
        catch (Throwable e) {
            logger.error("Error during handing search request: ", e);
            Response response = Response.serverError().build();
            return response;
        }
        finally {
            context.stop();
        }
    }

    private Response getMetricsInternal(Set<String> metricNames, boolean zeroIgnore) {
        List groups = manager.listMetricGroups();
        MetricNameSetFilter keyFilter = new MetricNameSetFilter(metricNames);
        ArrayList<MetricObject> metricObjects = new ArrayList<MetricObject>();
        for (String group : groups) {
            MetricRegistry registry = manager.getMetricRegistryByGroup(group);
            metricObjects.addAll(this.buildMetricRegistry(registry, (MetricFilter)keyFilter));
        }
        if (metricObjects.isEmpty()) {
            return Utils.buildResult(null, false, "The specified metric is not found!");
        }
        if (zeroIgnore) {
            ArrayList<MetricObject> allMetricObjects = metricObjects;
            metricObjects = new ArrayList();
            for (MetricObject o : allMetricObjects) {
                if (o == null || Utils.checkZero(o.getValue())) continue;
                metricObjects.add(o);
            }
        }
        return Utils.buildResult(metricObjects);
    }

    private List<MetricObject> buildMetricRegistry(MetricRegistry registry) {
        return this.buildMetricRegistry(registry, null);
    }

    private List<MetricObject> buildMetricRegistry(MetricRegistry registry, MetricFilter filter) {
        long ts = System.currentTimeMillis();
        MetricsCollector collector = MetricsCollectorFactory.createNew((CollectLevel)CollectLevel.NORMAL, (double)rateFactor, (double)durationFactor, (MetricFilter)filter);
        SortedMap gauges = filter == null ? registry.getGauges() : registry.getGauges(filter);
        for (Map.Entry entry : gauges.entrySet()) {
            collector.collect((MetricName)entry.getKey(), (Gauge)entry.getValue(), ts);
        }
        SortedMap counters = filter == null ? registry.getCounters() : registry.getCounters(filter);
        for (Map.Entry entry : counters.entrySet()) {
            collector.collect((MetricName)entry.getKey(), (Counter)entry.getValue(), ts);
        }
        SortedMap sortedMap = filter == null ? registry.getMeters() : registry.getMeters(filter);
        for (Map.Entry entry : sortedMap.entrySet()) {
            collector.collect((MetricName)entry.getKey(), (Meter)entry.getValue(), ts);
        }
        SortedMap sortedMap2 = filter == null ? registry.getHistograms() : registry.getHistograms(filter);
        for (Map.Entry entry : sortedMap2.entrySet()) {
            collector.collect((MetricName)entry.getKey(), (Histogram)entry.getValue(), ts);
        }
        SortedMap sortedMap3 = filter == null ? registry.getTimers() : registry.getTimers(filter);
        for (Map.Entry entry : sortedMap3.entrySet()) {
            collector.collect((MetricName)entry.getKey(), (Timer)entry.getValue(), ts);
        }
        SortedMap sortedMap4 = filter == null ? registry.getCompasses() : registry.getCompasses(filter);
        for (Map.Entry entry : sortedMap4.entrySet()) {
            collector.collect((MetricName)entry.getKey(), (Compass)entry.getValue(), ts);
        }
        SortedMap sortedMap5 = filter == null ? registry.getFastCompasses() : registry.getFastCompasses(filter);
        for (Map.Entry entry : sortedMap5.entrySet()) {
            collector.collect((MetricName)entry.getKey(), (FastCompass)entry.getValue(), ts);
        }
        SortedMap sortedMap6 = filter == null ? registry.getClusterHistograms(MetricFilter.ALL) : registry.getClusterHistograms(filter);
        for (Map.Entry entry : sortedMap6.entrySet()) {
            collector.collect((MetricName)entry.getKey(), (ClusterHistogram)entry.getValue(), ts);
        }
        return collector.build();
    }
}

