/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.metrics.rest;

import com.alibaba.metrics.IMetricManager;
import com.alibaba.metrics.Metric;
import com.alibaba.metrics.MetricFilter;
import com.alibaba.metrics.MetricLevel;
import com.alibaba.metrics.MetricManager;
import com.alibaba.metrics.MetricName;
import com.alibaba.metrics.MetricRegistry;
import com.alibaba.metrics.rest.Utils;
import java.util.List;
import java.util.Map;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/metrics/controller")
public class MetricsController {
    private static IMetricManager manager = MetricManager.getIMetricManager();

    @Path(value="/changeLevel/{group}/{metricPrefix}/{level}")
    @POST
    @Produces(value={"application/json;qs=0.1", "text/html"})
    public Response changeMetricLevel(@PathParam(value="group") String group, final @PathParam(value="metricPrefix") String metricPrefix, @PathParam(value="level") String level) {
        MetricLevel levelToChange;
        MetricFilter prefixFilter = new MetricFilter(){

            public boolean matches(MetricName name, Metric metric) {
                return name.getKey().startsWith(metricPrefix);
            }
        };
        try {
            levelToChange = MetricLevel.valueOf((String)level.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return Utils.buildResult(null, false, "Incorrect metric level!");
        }
        if ("all".equalsIgnoreCase(group)) {
            for (String groupName : manager.listMetricGroups()) {
                try {
                    MetricRegistry registry = manager.getMetricRegistryByGroup(groupName);
                    this.changeMetricLevel(registry, prefixFilter, levelToChange);
                }
                catch (Throwable e) {
                    return Utils.buildResult(null, false, e.getMessage());
                }
            }
            return Utils.buildResult(null, true, "");
        }
        List groups = manager.listMetricGroups();
        if (!groups.contains(group)) {
            return Utils.buildResult(null, false, "The specified group is not found!");
        }
        MetricRegistry registry = manager.getMetricRegistryByGroup(group);
        this.changeMetricLevel(registry, prefixFilter, levelToChange);
        return Utils.buildResult(null, true, "");
    }

    private void changeMetricLevel(MetricRegistry registry, MetricFilter filter, MetricLevel levelToChange) {
        for (Map.Entry entry : registry.getMetrics(filter).entrySet()) {
            ((MetricName)entry.getKey()).level(levelToChange);
        }
    }
}

