/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.metrics;

import com.alibaba.metrics.Clock;
import com.alibaba.metrics.Reservoir;
import com.alibaba.metrics.Snapshot;
import com.alibaba.metrics.ThreadLocalRandom;
import com.alibaba.metrics.WeightedSnapshot;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ExponentiallyDecayingReservoir
implements Reservoir {
    private static final int DEFAULT_SIZE = 1028;
    private static final double DEFAULT_ALPHA = 0.015;
    private static final long RESCALE_THRESHOLD = TimeUnit.HOURS.toNanos(1L);
    private final ConcurrentSkipListMap<Double, WeightedSnapshot.WeightedSample> values = new ConcurrentSkipListMap();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final double alpha;
    private final int size;
    private final AtomicLong count;
    private volatile long startTime;
    private final AtomicLong nextScaleTime;
    private final Clock clock;

    public ExponentiallyDecayingReservoir() {
        this(1028, 0.015);
    }

    public ExponentiallyDecayingReservoir(Clock clock) {
        this(1028, 0.015, clock);
    }

    public ExponentiallyDecayingReservoir(int size, double alpha) {
        this(size, alpha, Clock.defaultClock());
    }

    public ExponentiallyDecayingReservoir(int size, double alpha, Clock clock) {
        this.alpha = alpha;
        this.size = size;
        this.clock = clock;
        this.count = new AtomicLong(0L);
        this.startTime = this.currentTimeInSeconds();
        this.nextScaleTime = new AtomicLong(clock.getTick() + RESCALE_THRESHOLD);
    }

    public int size() {
        return (int)Math.min((long)this.size, this.count.get());
    }

    public void update(long value) {
        this.update(value, this.currentTimeInSeconds());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(long value, long timestamp) {
        this.rescaleIfNeeded();
        this.lockForRegularUsage();
        try {
            double itemWeight = this.weight(timestamp - this.startTime);
            double priority = itemWeight / ThreadLocalRandom.current().nextDouble();
            long newCount = this.count.incrementAndGet();
            if (newCount <= (long)this.size) {
                WeightedSnapshot.WeightedSample sample = new WeightedSnapshot.WeightedSample(value, itemWeight);
                this.values.put(priority, sample);
            } else {
                Double first = this.values.firstKey();
                if (first < priority) {
                    if (this.values.containsKey(priority)) {
                        WeightedSnapshot.WeightedSample sample = this.values.get(priority);
                        sample.value = value;
                        sample.weight = itemWeight;
                    } else {
                        WeightedSnapshot.WeightedSample firstSample;
                        while ((firstSample = this.values.remove(first)) == null) {
                            first = this.values.firstKey();
                        }
                        firstSample.value = value;
                        firstSample.weight = itemWeight;
                        this.values.putIfAbsent(priority, firstSample);
                    }
                }
            }
        }
        finally {
            this.unlockForRegularUsage();
        }
    }

    private void rescaleIfNeeded() {
        long next;
        long now = this.clock.getTick();
        if (now >= (next = this.nextScaleTime.get())) {
            this.rescale(now, next);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Snapshot getSnapshot() {
        this.rescaleIfNeeded();
        this.lockForRegularUsage();
        try {
            WeightedSnapshot weightedSnapshot = new WeightedSnapshot(this.values.values());
            return weightedSnapshot;
        }
        catch (Exception e) {
            InvalidSnapshot invalidSnapshot = new InvalidSnapshot();
            return invalidSnapshot;
        }
        finally {
            this.unlockForRegularUsage();
        }
    }

    private long currentTimeInSeconds() {
        return TimeUnit.MILLISECONDS.toSeconds(this.clock.getTime());
    }

    private double weight(long t) {
        return Math.exp(this.alpha * (double)t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rescale(long now, long next) {
        if (this.nextScaleTime.compareAndSet(next, now + RESCALE_THRESHOLD)) {
            this.lockForRescale();
            try {
                long oldStartTime = this.startTime;
                this.startTime = this.currentTimeInSeconds();
                double scalingFactor = Math.exp(-this.alpha * (double)(this.startTime - oldStartTime));
                if (Double.compare(scalingFactor, 0.0) == 0) {
                    this.values.clear();
                } else {
                    ArrayList keys = new ArrayList(this.values.keySet());
                    for (Double key : keys) {
                        WeightedSnapshot.WeightedSample sample = this.values.remove(key);
                        WeightedSnapshot.WeightedSample newSample = new WeightedSnapshot.WeightedSample(sample.value, sample.weight * scalingFactor);
                        this.values.put(key * scalingFactor, newSample);
                    }
                }
                this.count.set(this.values.size());
            }
            finally {
                this.unlockForRescale();
            }
        }
    }

    private void unlockForRescale() {
        this.lock.writeLock().unlock();
    }

    private void lockForRescale() {
        this.lock.writeLock().lock();
    }

    private void lockForRegularUsage() {
        this.lock.readLock().lock();
    }

    private void unlockForRegularUsage() {
        this.lock.readLock().unlock();
    }

    private class InvalidSnapshot
    implements Snapshot {
        final long[] data = new long[0];

        private InvalidSnapshot() {
        }

        public double getValue(double quantile) {
            return -10001.0;
        }

        public long[] getValues() {
            return this.data;
        }

        public int size() {
            return 0;
        }

        public double getMedian() {
            return -10001.0;
        }

        public double get75thPercentile() {
            return -10001.0;
        }

        public double get95thPercentile() {
            return -10001.0;
        }

        public double get98thPercentile() {
            return -10001.0;
        }

        public double get99thPercentile() {
            return -10001.0;
        }

        public double get999thPercentile() {
            return -10001.0;
        }

        public long getMax() {
            return -10001L;
        }

        public double getMean() {
            return -10001.0;
        }

        public long getMin() {
            return -10001L;
        }

        public double getStdDev() {
            return -10001.0;
        }

        public void dump(OutputStream output) {
        }
    }
}

