/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.metrics;

import com.alibaba.metrics.Metric;
import java.util.Arrays;
import java.util.Map;

public abstract class ClusterHistogram
implements Metric {
    private static final int MAX_BUCKET_COUNT = Integer.getInteger("com.alibaba.metrics.maxClusterHistogramBucketCount", 100);
    protected long[] buckets;

    public ClusterHistogram(long[] buckets) {
        if (buckets == null) {
            this.buckets = new long[]{1L, 5L, 10L, 25L, 50L, 75L, 100L, 250L, 500L, 750L, 1000L};
        } else {
            if (buckets.length == 0) {
                throw new IllegalStateException("The number of buckets should not be null or 0.");
            }
            if (buckets.length > MAX_BUCKET_COUNT) {
                throw new IllegalStateException("The number of buckets should be no larger than " + MAX_BUCKET_COUNT);
            }
            this.buckets = buckets;
            this.buckets = new long[buckets.length + 1];
            for (int i = 0; i < buckets.length; ++i) {
                this.buckets[i] = buckets[i];
            }
            this.buckets[buckets.length] = Long.MAX_VALUE;
            Arrays.sort(this.buckets);
        }
    }

    public ClusterHistogram() {
        this(null);
    }

    public abstract void update(long var1);

    public long[] getBuckets() {
        return this.buckets;
    }

    public abstract Map<Long, Map<Long, Long>> getBucketValues(long var1);
}

