/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.metrics.common.filter;

import com.alibaba.metrics.MetricLevel;
import com.alibaba.metrics.common.config.MetricsCollectPeriodConfig;
import com.alibaba.metrics.common.filter.TimeMetricLevelFilter;

public class BucketMetricLevelFilter
extends TimeMetricLevelFilter {
    public BucketMetricLevelFilter() {
    }

    public BucketMetricLevelFilter(MetricsCollectPeriodConfig config) {
        super(config);
    }

    @Override
    public void beforeReport() {
        MetricLevel[] levels;
        if (this.config == null) {
            return;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (MetricLevel level : levels = MetricLevel.values()) {
            int period = this.config.period(level);
            if (period < 0) continue;
            TimeMetricLevelFilter.MetricsLevelInfo metricsLevelInfo = this.levelInfos[level.ordinal()];
            int interval = period * 1000;
            long bucketEdge = currentTimeMillis / (long)interval * (long)interval;
            if (metricsLevelInfo.lastReportTimeStamp >= bucketEdge) continue;
            metricsLevelInfo.allow = true;
            metricsLevelInfo.lastReportTimeStamp = currentTimeMillis;
        }
    }

    @Override
    public void afterReport() {
        if (this.config == null) {
            return;
        }
        for (TimeMetricLevelFilter.MetricsLevelInfo info : this.levelInfos) {
            if (!info.allow.booleanValue()) continue;
            info.allow = false;
        }
    }
}

