/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.metrics.common;

import com.alibaba.metrics.MetricFilter;
import com.alibaba.metrics.common.ClassifiedMetricsCollector;
import com.alibaba.metrics.common.CollectLevel;
import com.alibaba.metrics.common.CompactMetricsCollector;
import com.alibaba.metrics.common.MetricsCollector;
import com.alibaba.metrics.common.NormalMetricsCollector;
import java.util.HashMap;
import java.util.Map;

public class MetricsCollectorFactory {
    public static MetricsCollector createNew(Map<String, String> globalTags, double rateFactor, double durationFactor) {
        return MetricsCollectorFactory.createNew(CollectLevel.NORMAL, globalTags, rateFactor, durationFactor, null);
    }

    public static MetricsCollector createNew(CollectLevel level, Map<String, String> globalTags, double rateFactor, double durationFactor) {
        return MetricsCollectorFactory.createNew(level, globalTags, rateFactor, durationFactor, null);
    }

    public static MetricsCollector createNew(CollectLevel level, double rateFactor, double durationFactor, MetricFilter filter) {
        return MetricsCollectorFactory.createNew(level, new HashMap<String, String>(), rateFactor, durationFactor, filter);
    }

    public static MetricsCollector createNew(double rateFactor, double durationFactor, MetricFilter filter) {
        return MetricsCollectorFactory.createNew(CollectLevel.NORMAL, new HashMap<String, String>(), rateFactor, durationFactor, filter);
    }

    public static MetricsCollector createNew(CollectLevel collectLevel, Map<String, String> globalTags, double rateFactor, double durationFactor, MetricFilter filter) {
        switch (collectLevel) {
            case COMPACT: {
                return new CompactMetricsCollector(globalTags, rateFactor, durationFactor, filter);
            }
            case NORMAL: {
                return new NormalMetricsCollector(globalTags, rateFactor, durationFactor, filter);
            }
            case CLASSIFIER: {
                return new ClassifiedMetricsCollector(globalTags, rateFactor, durationFactor, filter);
            }
            case COMPLETE: {
                throw new UnsupportedOperationException("Currently not supported!");
            }
        }
        throw new IllegalStateException("Unsupported CollectLevel: " + (Object)((Object)collectLevel));
    }
}

