/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.metrics.common;

import com.alibaba.metrics.BucketCounter;
import com.alibaba.metrics.ClusterHistogram;
import com.alibaba.metrics.Collector;
import com.alibaba.metrics.Compass;
import com.alibaba.metrics.FastCompass;
import com.alibaba.metrics.MetricFilter;
import com.alibaba.metrics.MetricName;
import com.alibaba.metrics.common.MetricObject;
import com.alibaba.metrics.common.config.MetricsCollectPeriodConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public abstract class MetricsCollector
implements Collector {
    protected static final int MAX_COLLECT_NUM = Integer.getInteger("com.alibaba.metrics.collector.maxCollectNumber", 10000);
    protected final List<MetricObject> metrics = new ArrayList<MetricObject>();
    protected Map<String, String> globalTags;
    protected MetricsCollectPeriodConfig metricsCollectPeriodConfig;
    protected double rateFactor;
    protected double durationFactor;
    private boolean collectNAValue;
    private double notAvailable;
    protected MetricFilter filter;

    MetricsCollector(Map<String, String> globalTags, double rateFactor, double durationFactor, MetricFilter filter) {
        this(globalTags, rateFactor, durationFactor, filter, false);
    }

    MetricsCollector(Map<String, String> globalTags, double rateFactor, double durationFactor, MetricFilter filter, boolean collectNAValue) {
        this.globalTags = globalTags;
        this.rateFactor = rateFactor;
        this.durationFactor = durationFactor;
        this.filter = filter;
        this.collectNAValue = collectNAValue;
        this.notAvailable = -10001.0 * durationFactor;
        this.metricsCollectPeriodConfig = new MetricsCollectPeriodConfig();
    }

    public MetricsCollector addMetric(MetricName name, String suffix, Object value, long timestamp) {
        return this.addMetric(name, suffix, value, timestamp, MetricObject.MetricType.GAUGE);
    }

    public MetricsCollector addMetric(MetricName name, String suffix, Object value, long timestamp, MetricObject.MetricType type) {
        MetricName fullName = name.resolve(suffix);
        return this.addMetric(fullName, value, timestamp, type, this.metricsCollectPeriodConfig.period(fullName.getMetricLevel()));
    }

    public MetricsCollector addMetric(MetricName name, String suffix, Object value, long timestamp, MetricObject.MetricType type, int interval) {
        MetricName fullName = name.resolve(suffix);
        return this.addMetric(fullName, value, timestamp, type, interval);
    }

    public MetricsCollector addMetric(MetricObject object) {
        if (this.metrics.size() >= MAX_COLLECT_NUM) {
            return this;
        }
        if (!this.collectNAValue && object.getValue() instanceof Double && (Double)object.getValue() == this.notAvailable) {
            return this;
        }
        if ((this.filter == null || this.filter.matches(MetricName.build((String[])new String[]{object.getMetric()}), null)) && object.getValue() != null) {
            this.metrics.add(object);
        }
        return this;
    }

    public MetricsCollector addMetric(MetricName name, MetricName suffix, Object value, long timestamp, MetricObject.MetricType type, int interval) {
        MetricName fullName = MetricName.join((MetricName[])new MetricName[]{name, suffix});
        return this.addMetric(fullName, value, timestamp, type, interval);
    }

    public MetricsCollector addMetric(MetricName fullName, Object value, long timestamp, MetricObject.MetricType type, int interval) {
        MetricObject obj = MetricObject.named(fullName.getKey()).withType(type).withTimestamp(timestamp).withValue(value).withTags(this.merge(this.globalTags, fullName.getTags())).withLevel(fullName.getMetricLevel()).withInterval(interval).build();
        return this.addMetric(obj);
    }

    public List<MetricObject> build() {
        return this.metrics;
    }

    public void clear() {
        this.metrics.clear();
    }

    public void collect(MetricName name, FastCompass fastCompass, long timestamp) {
        int bucketInterval = fastCompass.getBucketInterval();
        long start = this.getNormalizedStartTime(timestamp, bucketInterval);
        long totalCount = 0L;
        long totalRt = 0L;
        long successCount = 0L;
        long hitCount = -1L;
        Map countPerCategory = fastCompass.getMethodCountPerCategory(start);
        for (Map.Entry entry : countPerCategory.entrySet()) {
            if (((Map)entry.getValue()).containsKey(start)) {
                this.addMetric(name, (String)entry.getKey() + "_bucket_count", ((Map)entry.getValue()).get(start), start, MetricObject.MetricType.DELTA, bucketInterval);
                totalCount += ((Long)((Map)entry.getValue()).get(start)).longValue();
                if ("success".equals(entry.getKey())) {
                    successCount += ((Long)((Map)entry.getValue()).get(start)).longValue();
                }
                if (!"hit".equals(entry.getKey())) continue;
                hitCount = (Long)((Map)entry.getValue()).get(start);
                successCount += ((Long)((Map)entry.getValue()).get(start)).longValue();
                continue;
            }
            this.addMetric(name, (String)entry.getKey() + "_bucket_count", (Object)0L, start, MetricObject.MetricType.DELTA, bucketInterval);
        }
        for (Map.Entry entry : fastCompass.getMethodRtPerCategory(start).entrySet()) {
            if (!((Map)entry.getValue()).containsKey(start)) continue;
            totalRt += ((Long)((Map)entry.getValue()).get(start)).longValue();
        }
        this.addMetric(name, "bucket_count", (Object)totalCount, start, MetricObject.MetricType.DELTA, bucketInterval);
        this.addMetric(name, "bucket_sum", (Object)totalRt, start, MetricObject.MetricType.DELTA, bucketInterval);
        this.addMetric(name, "qps", (Object)this.rate(totalCount, bucketInterval), start, MetricObject.MetricType.GAUGE, bucketInterval);
        this.addMetric(name, "rt", (Object)this.rate(totalRt, totalCount), start, MetricObject.MetricType.GAUGE, bucketInterval);
        this.addMetric(name, "success_rate", (Object)this.ratio(successCount, totalCount), start, MetricObject.MetricType.GAUGE, bucketInterval);
        if (hitCount >= 0L) {
            this.addMetric(name, "hit_rate", (Object)this.ratio(hitCount, successCount), start, MetricObject.MetricType.GAUGE, bucketInterval);
        }
    }

    public void collect(MetricName name, ClusterHistogram clusterHistogram, long timestamp) {
        long start = this.getNormalizedStartTime(timestamp, this.metricsCollectPeriodConfig.period(name.getMetricLevel()));
        Map values = clusterHistogram.getBucketValues(start);
        long[] buckets = clusterHistogram.getBuckets();
        if (values.containsKey(start)) {
            Map bucketAndValues = (Map)values.get(start);
            for (long bucket : buckets) {
                this.addMetric(name.tagged(new String[]{"bucket", bucket == Long.MAX_VALUE ? "+Inf" : Long.toString(bucket)}), "cluster_percentile", (Object)(bucketAndValues.containsKey(bucket) ? (Long)bucketAndValues.get(bucket) : 0L), start, MetricObject.MetricType.PERCENTILE);
            }
        } else {
            this.addMetric(name, "cluster_percentile", (Object)0L, start, MetricObject.MetricType.PERCENTILE);
        }
    }

    protected Map<String, String> merge(Map<String, String> map1, Map<String, String> map2) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.putAll(map1);
        result.putAll(map2);
        return result;
    }

    protected double convertRate(double rate) {
        return rate * this.rateFactor;
    }

    protected double convertDuration(double duration) {
        return duration * this.durationFactor;
    }

    protected void addInstantCountMetric(Map<Long, Long> instantCount, MetricName name, int countInterval, long timestamp) {
        long start = this.getNormalizedStartTime(timestamp, countInterval);
        if (instantCount.containsKey(start)) {
            this.addMetric(name, "bucket_count", (Object)instantCount.get(start), start, MetricObject.MetricType.DELTA, countInterval);
            this.addMetric(name, "qps", (Object)this.rate(instantCount.get(start), countInterval), start, MetricObject.MetricType.GAUGE, countInterval);
        } else {
            this.addMetric(name, "bucket_count", (Object)0L, start, MetricObject.MetricType.DELTA, countInterval);
            this.addMetric(name, "qps", (Object)0.0, start, MetricObject.MetricType.GAUGE, countInterval);
        }
    }

    protected void addCompassErrorCode(MetricName name, Compass compass, long timestamp) {
        int countInterval = compass.getInstantCountInterval();
        long start = this.getNormalizedStartTime(timestamp, countInterval);
        for (Map.Entry entry : compass.getErrorCodeCounts().entrySet()) {
            this.addMetric(name, MetricName.build((String[])new String[]{"error.count"}).tagged(new String[]{"error", (String)entry.getKey()}), (Object)((BucketCounter)entry.getValue()).getCount(), timestamp, MetricObject.MetricType.COUNTER, this.metricsCollectPeriodConfig.period(name.getMetricLevel()));
            MetricName errorName = MetricName.build((String[])new String[]{"error_bucket_count"}).tagged(new String[]{"error", (String)entry.getKey()});
            Map errorCodeBucket = ((BucketCounter)entry.getValue()).getBucketCounts();
            if (errorCodeBucket.containsKey(start)) {
                this.addMetric(name, errorName, errorCodeBucket.get(start), start, MetricObject.MetricType.DELTA, countInterval);
                continue;
            }
            this.addMetric(name, errorName, (Object)0L, start, MetricObject.MetricType.DELTA, countInterval);
        }
    }

    protected void addAddonMetric(MetricName name, Compass compass, long timestamp) {
        int countInterval = compass.getInstantCountInterval();
        long start = this.getNormalizedStartTime(timestamp, countInterval);
        for (Map.Entry entry : compass.getAddonCounts().entrySet()) {
            MetricName addonName = MetricName.build((String[])new String[]{(String)entry.getKey(), "count"});
            this.addMetric(name, addonName, (Object)((BucketCounter)entry.getValue()).getCount(), timestamp, MetricObject.MetricType.COUNTER, this.metricsCollectPeriodConfig.period(name.getMetricLevel()));
            MetricName addonBucketName = MetricName.build((String[])new String[]{(String)entry.getKey() + "_bucket_count"});
            Map addOnBucket = ((BucketCounter)entry.getValue()).getBucketCounts();
            if (addOnBucket.containsKey(start)) {
                this.addMetric(name, addonBucketName, addOnBucket.get(start), start, MetricObject.MetricType.DELTA, countInterval);
                Long successTotal = (Long)compass.getBucketSuccessCount().getBucketCounts().get(start);
                if (successTotal == null) {
                    successTotal = (Long)addOnBucket.get(start);
                }
                this.addMetric(name, (String)entry.getKey() + "_rate", (Object)this.ratio((Long)addOnBucket.get(start), successTotal), start, MetricObject.MetricType.GAUGE, compass.getInstantCountInterval());
                continue;
            }
            this.addMetric(name, addonBucketName, (Object)0L, start, MetricObject.MetricType.DELTA, countInterval);
            this.addMetric(name, (String)entry.getKey() + "_rate", (Object)0.0, start, MetricObject.MetricType.GAUGE, compass.getInstantCountInterval());
        }
    }

    protected void addInstantSuccessCount(MetricName name, Compass compass, long timestamp) {
        this.addMetric(name, "success_count", (Object)compass.getBucketSuccessCount().getCount(), timestamp, MetricObject.MetricType.COUNTER);
        int countInterval = compass.getInstantCountInterval();
        long start = this.getNormalizedStartTime(timestamp, countInterval);
        Map successCount = compass.getBucketSuccessCount().getBucketCounts();
        if (successCount.containsKey(start)) {
            this.addMetric(name, "success_bucket_count", successCount.get(start), start, MetricObject.MetricType.DELTA, countInterval);
            Long total = (Long)compass.getInstantCount().get(start);
            if (total == null) {
                total = (Long)successCount.get(start);
            }
            this.addMetric(name, "success_rate", (Object)this.ratio((Long)successCount.get(start), total), start, MetricObject.MetricType.GAUGE, compass.getInstantCountInterval());
        } else {
            this.addMetric(name, "success_bucket_count", (Object)0L, start, MetricObject.MetricType.DELTA, countInterval);
            this.addMetric(name, "success_rate", (Object)0.0, start, MetricObject.MetricType.GAUGE, countInterval);
        }
    }

    protected double rate(long data, long interval) {
        if (interval == 0L) {
            return 0.0;
        }
        return 1.0 * (double)data / (double)interval;
    }

    protected double ratio(long data, long total) {
        if (data > total) {
            return 1.0;
        }
        if (total == 0L) {
            return 0.0;
        }
        return 1.0 * (double)data / (double)total;
    }

    public void setMetricsCollectPeriodConfig(MetricsCollectPeriodConfig metricsCollectPeriodConfig) {
        this.metricsCollectPeriodConfig = metricsCollectPeriodConfig;
    }

    private long getNormalizedStartTime(long current, int interval) {
        return (TimeUnit.MILLISECONDS.toSeconds(current) - (long)interval) / (long)interval * (long)interval * 1000L;
    }
}

