/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jvm.sandbox.api.util;

public abstract class LazyGet<T> {
    private volatile boolean isInit = false;
    private volatile T object;

    protected abstract T initialValue() throws Throwable;

    public T get() {
        if (this.isInit) {
            return this.object;
        }
        try {
            this.object = this.initialValue();
            this.isInit = true;
            return this.object;
        }
        catch (Throwable throwable) {
            throw new LazyGetUnCaughtException(throwable);
        }
    }

    private static class LazyGetUnCaughtException
    extends RuntimeException {
        LazyGetUnCaughtException(Throwable cause) {
            super(cause);
        }
    }
}

