/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jvm.sandbox.api.listener.ext;

import com.alibaba.jvm.sandbox.api.event.Event;
import com.alibaba.jvm.sandbox.api.filter.ExtFilter;
import com.alibaba.jvm.sandbox.api.filter.Filter;
import com.alibaba.jvm.sandbox.api.listener.EventListener;
import com.alibaba.jvm.sandbox.api.listener.ext.AdviceAdapterListener;
import com.alibaba.jvm.sandbox.api.listener.ext.AdviceListener;
import com.alibaba.jvm.sandbox.api.listener.ext.EventWatchCondition;
import com.alibaba.jvm.sandbox.api.listener.ext.EventWatcher;
import com.alibaba.jvm.sandbox.api.resource.ModuleEventWatcher;
import com.alibaba.jvm.sandbox.api.util.GaArrayUtils;
import com.alibaba.jvm.sandbox.api.util.GaCollectionUtils;
import com.alibaba.jvm.sandbox.api.util.GaStringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class EventWatchBuilder {
    private final ModuleEventWatcher moduleEventWatcher;
    private final PatternType patternType;
    private List<BuildingForClass> bfClasses = new ArrayList<BuildingForClass>();

    public EventWatchBuilder(ModuleEventWatcher moduleEventWatcher) {
        this(moduleEventWatcher, PatternType.WILDCARD);
    }

    public EventWatchBuilder(ModuleEventWatcher moduleEventWatcher, PatternType patternType) {
        this.moduleEventWatcher = moduleEventWatcher;
        this.patternType = patternType;
    }

    private static boolean patternMatching(String string, String pattern, PatternType patternType) {
        switch (patternType) {
            case WILDCARD: {
                return GaStringUtils.matching(string, pattern);
            }
            case REGEX: {
                return string.matches(pattern);
            }
        }
        return false;
    }

    private static String[] toRegexQuoteArray(String[] stringArray) {
        if (null == stringArray) {
            return null;
        }
        String[] regexQuoteArray = new String[stringArray.length];
        for (int index = 0; index < stringArray.length; ++index) {
            regexQuoteArray[index] = Pattern.quote(stringArray[index]);
        }
        return regexQuoteArray;
    }

    public IBuildingForClass onAnyClass() {
        switch (this.patternType) {
            case REGEX: {
                return this.onClass(".*");
            }
        }
        return this.onClass("*");
    }

    public IBuildingForClass onClass(Class<?> clazz) {
        switch (this.patternType) {
            case REGEX: {
                return this.onClass(Pattern.quote(GaStringUtils.getJavaClassName(clazz)));
            }
        }
        return this.onClass(GaStringUtils.getJavaClassName(clazz));
    }

    public IBuildingForClass onClass(String pattern) {
        return GaCollectionUtils.add(this.bfClasses, new BuildingForClass(pattern));
    }

    private EventWatchCondition toEventWatchCondition() {
        final ArrayList<Filter> filters = new ArrayList<Filter>();
        for (final BuildingForClass bfClass : this.bfClasses) {
            Filter filter = new Filter(){

                @Override
                public boolean doClassFilter(int access, String javaClassName, String superClassTypeJavaClassName, String[] interfaceTypeJavaClassNameArray, String[] annotationTypeJavaClassNameArray) {
                    return (access & bfClass.withAccess) == bfClass.withAccess && EventWatchBuilder.patternMatching(javaClassName, bfClass.pattern, EventWatchBuilder.this.patternType) && bfClass.hasInterfaceTypes.patternHas(interfaceTypeJavaClassNameArray) && bfClass.hasAnnotationTypes.patternHas(annotationTypeJavaClassNameArray);
                }

                @Override
                public boolean doMethodFilter(int access, String javaMethodName, String[] parameterTypeJavaClassNameArray, String[] throwsTypeJavaClassNameArray, String[] annotationTypeJavaClassNameArray) {
                    if (bfClass.bfBehaviors.isEmpty()) {
                        return false;
                    }
                    for (BuildingForBehavior bfBehavior : bfClass.bfBehaviors) {
                        if ((access & bfBehavior.withAccess) != bfBehavior.withAccess || !EventWatchBuilder.patternMatching(javaMethodName, bfBehavior.pattern, EventWatchBuilder.this.patternType) || !bfBehavior.withParameterTypes.patternWith(parameterTypeJavaClassNameArray) || !bfBehavior.hasExceptionTypes.patternHas(throwsTypeJavaClassNameArray) || !bfBehavior.hasAnnotationTypes.patternHas(annotationTypeJavaClassNameArray)) continue;
                        return true;
                    }
                    return false;
                }
            };
            filters.add(this.makeExtFilter(filter, bfClass));
        }
        return new EventWatchCondition(){

            @Override
            public Filter[] getOrFilterArray() {
                return filters.toArray(new Filter[0]);
            }
        };
    }

    private Filter makeExtFilter(Filter filter, BuildingForClass bfClass) {
        return ExtFilter.ExtFilterFactory.make(filter, bfClass.isIncludeSubClasses, bfClass.isIncludeBootstrap);
    }

    private ProgressGroup toProgressGroup(List<ModuleEventWatcher.Progress> progresses) {
        if (progresses.isEmpty()) {
            return null;
        }
        return new ProgressGroup(progresses);
    }

    private EventWatcher build(EventListener listener, ModuleEventWatcher.Progress progress, Event.Type ... eventTypes) {
        final int watchId = this.moduleEventWatcher.watch(this.toEventWatchCondition(), listener, progress, eventTypes);
        return new EventWatcher(){
            final List<ModuleEventWatcher.Progress> progresses = new ArrayList<ModuleEventWatcher.Progress>();

            @Override
            public int getWatchId() {
                return watchId;
            }

            @Override
            public IBuildingForUnWatching withProgress(ModuleEventWatcher.Progress progress) {
                if (null != progress) {
                    this.progresses.add(progress);
                }
                return this;
            }

            @Override
            public void onUnWatched() {
                EventWatchBuilder.this.moduleEventWatcher.delete(watchId, EventWatchBuilder.this.toProgressGroup(this.progresses));
            }
        };
    }

    private class Group {
        final String[] patternArray;

        Group(String[] patternArray) {
            this.patternArray = GaArrayUtils.isEmpty(patternArray) ? new String[]{} : patternArray;
        }

        boolean anyMatching(String[] stringArray, String pattern) {
            if (GaArrayUtils.isEmpty(stringArray)) {
                return false;
            }
            for (String string : stringArray) {
                if (!EventWatchBuilder.patternMatching(string, pattern, EventWatchBuilder.this.patternType)) continue;
                return true;
            }
            return false;
        }

        boolean matchingHas(String[] stringArray) {
            for (String pattern : this.patternArray) {
                if (this.anyMatching(stringArray, pattern)) continue;
                return false;
            }
            return true;
        }

        boolean matchingWith(String[] stringArray) {
            int length = GaArrayUtils.getLength(stringArray);
            if (length != GaArrayUtils.getLength(this.patternArray)) {
                return false;
            }
            for (int index = 0; index < length; ++index) {
                if (EventWatchBuilder.patternMatching(stringArray[index], this.patternArray[index], EventWatchBuilder.this.patternType)) continue;
                return false;
            }
            return true;
        }
    }

    private class PatternGroupList {
        final List<Group> groups = new ArrayList<Group>();

        private PatternGroupList() {
        }

        void add(String ... patternArray) {
            this.groups.add(new Group(patternArray));
        }

        boolean patternWith(String[] stringArray) {
            if (this.groups.isEmpty()) {
                return true;
            }
            for (Group group : this.groups) {
                if (!group.matchingWith(stringArray)) continue;
                return true;
            }
            return false;
        }

        boolean patternHas(String[] stringArray) {
            if (this.groups.isEmpty()) {
                return true;
            }
            for (Group group : this.groups) {
                if (!group.matchingHas(stringArray)) continue;
                return true;
            }
            return false;
        }
    }

    private static class ProgressGroup
    implements ModuleEventWatcher.Progress {
        private final List<ModuleEventWatcher.Progress> progresses;

        ProgressGroup(List<ModuleEventWatcher.Progress> progresses) {
            this.progresses = progresses;
        }

        @Override
        public void begin(int total) {
            for (ModuleEventWatcher.Progress progress : this.progresses) {
                progress.begin(total);
            }
        }

        @Override
        public void progressOnSuccess(Class<?> clazz, int index) {
            for (ModuleEventWatcher.Progress progress : this.progresses) {
                progress.progressOnSuccess(clazz, index);
            }
        }

        @Override
        public void progressOnFailed(Class<?> clazz, int index, Throwable cause) {
            for (ModuleEventWatcher.Progress progress : this.progresses) {
                progress.progressOnFailed(clazz, index, cause);
            }
        }

        @Override
        public void finish(int cCnt, int mCnt) {
            for (ModuleEventWatcher.Progress progress : this.progresses) {
                progress.finish(cCnt, mCnt);
            }
        }
    }

    private class BuildingForWatching
    implements IBuildingForWatching {
        private final Set<Event.Type> eventTypeSet = new HashSet<Event.Type>();
        private final List<ModuleEventWatcher.Progress> progresses = new ArrayList<ModuleEventWatcher.Progress>();

        private BuildingForWatching() {
        }

        @Override
        public IBuildingForWatching withProgress(ModuleEventWatcher.Progress progress) {
            if (null != progress) {
                this.progresses.add(progress);
            }
            return this;
        }

        @Override
        public IBuildingForWatching withCall() {
            this.eventTypeSet.add(Event.Type.CALL_BEFORE);
            this.eventTypeSet.add(Event.Type.CALL_RETURN);
            this.eventTypeSet.add(Event.Type.CALL_THROWS);
            return this;
        }

        @Override
        public IBuildingForWatching withLine() {
            this.eventTypeSet.add(Event.Type.LINE);
            return this;
        }

        @Override
        public EventWatcher onWatch(AdviceListener adviceListener) {
            this.eventTypeSet.add(Event.Type.BEFORE);
            this.eventTypeSet.add(Event.Type.RETURN);
            this.eventTypeSet.add(Event.Type.THROWS);
            this.eventTypeSet.add(Event.Type.IMMEDIATELY_RETURN);
            this.eventTypeSet.add(Event.Type.IMMEDIATELY_THROWS);
            return EventWatchBuilder.this.build(new AdviceAdapterListener(adviceListener), EventWatchBuilder.this.toProgressGroup(this.progresses), this.eventTypeSet.toArray(Event.Type.EMPTY));
        }

        @Override
        public EventWatcher onWatch(EventListener eventListener, Event.Type ... eventTypeArray) {
            return EventWatchBuilder.this.build(eventListener, EventWatchBuilder.this.toProgressGroup(this.progresses), eventTypeArray);
        }
    }

    private class BuildingForBehavior
    implements IBuildingForBehavior {
        private final BuildingForClass bfClass;
        private final String pattern;
        private int withAccess = 0;
        private final PatternGroupList withParameterTypes = new PatternGroupList();
        private final PatternGroupList hasExceptionTypes = new PatternGroupList();
        private final PatternGroupList hasAnnotationTypes = new PatternGroupList();

        BuildingForBehavior(BuildingForClass bfClass, String pattern) {
            this.bfClass = bfClass;
            this.pattern = pattern;
        }

        @Override
        public IBuildingForBehavior withAccess(int access) {
            this.withAccess |= access;
            return this;
        }

        @Override
        public IBuildingForBehavior withEmptyParameterTypes() {
            this.withParameterTypes.add(new String[0]);
            return this;
        }

        @Override
        public IBuildingForBehavior withParameterTypes(String ... patterns) {
            this.withParameterTypes.add(patterns);
            return this;
        }

        @Override
        public IBuildingForBehavior withParameterTypes(Class<?> ... classes) {
            switch (EventWatchBuilder.this.patternType) {
                case REGEX: {
                    return this.withParameterTypes(EventWatchBuilder.toRegexQuoteArray(GaStringUtils.getJavaClassNameArray(classes)));
                }
            }
            return this.withParameterTypes(GaStringUtils.getJavaClassNameArray(classes));
        }

        @Override
        public IBuildingForBehavior hasExceptionTypes(String ... patterns) {
            this.hasExceptionTypes.add(patterns);
            return this;
        }

        @Override
        public IBuildingForBehavior hasExceptionTypes(Class<?> ... classes) {
            switch (EventWatchBuilder.this.patternType) {
                case REGEX: {
                    return this.hasExceptionTypes(EventWatchBuilder.toRegexQuoteArray(GaStringUtils.getJavaClassNameArray(classes)));
                }
            }
            return this.hasExceptionTypes(GaStringUtils.getJavaClassNameArray(classes));
        }

        @Override
        public IBuildingForBehavior hasAnnotationTypes(String ... patterns) {
            this.hasAnnotationTypes.add(patterns);
            return this;
        }

        @Override
        public IBuildingForBehavior hasAnnotationTypes(Class<?> ... classes) {
            switch (EventWatchBuilder.this.patternType) {
                case REGEX: {
                    return this.hasAnnotationTypes(EventWatchBuilder.toRegexQuoteArray(GaStringUtils.getJavaClassNameArray(classes)));
                }
            }
            return this.hasAnnotationTypes(GaStringUtils.getJavaClassNameArray(classes));
        }

        @Override
        public IBuildingForBehavior onBehavior(String pattern) {
            return this.bfClass.onBehavior(pattern);
        }

        @Override
        public IBuildingForClass onClass(String pattern) {
            return EventWatchBuilder.this.onClass(pattern);
        }

        @Override
        public IBuildingForClass onClass(Class<?> clazz) {
            return EventWatchBuilder.this.onClass(clazz);
        }

        @Override
        public IBuildingForClass onAnyClass() {
            return EventWatchBuilder.this.onAnyClass();
        }

        @Override
        public IBuildingForWatching onWatching() {
            return new BuildingForWatching();
        }

        @Override
        public EventWatcher onWatch(AdviceListener adviceListener) {
            return EventWatchBuilder.this.build(new AdviceAdapterListener(adviceListener), null, new Event.Type[]{Event.Type.BEFORE, Event.Type.RETURN, Event.Type.THROWS, Event.Type.IMMEDIATELY_RETURN, Event.Type.IMMEDIATELY_THROWS});
        }

        @Override
        @Deprecated
        public EventWatcher onWatch(AdviceListener adviceListener, Event.Type ... eventTypeArray) {
            return this.onWatch(adviceListener);
        }

        @Override
        public EventWatcher onWatch(EventListener eventListener, Event.Type ... eventTypeArray) {
            return EventWatchBuilder.this.build(eventListener, null, eventTypeArray);
        }
    }

    private class BuildingForClass
    implements IBuildingForClass {
        private final String pattern;
        private int withAccess = 0;
        private boolean isIncludeSubClasses = false;
        private boolean isIncludeBootstrap = false;
        private final PatternGroupList hasInterfaceTypes = new PatternGroupList();
        private final PatternGroupList hasAnnotationTypes = new PatternGroupList();
        private final List<BuildingForBehavior> bfBehaviors = new ArrayList<BuildingForBehavior>();

        BuildingForClass(String pattern) {
            this.pattern = pattern;
        }

        @Override
        public IBuildingForClass includeBootstrap() {
            this.isIncludeBootstrap = true;
            return this;
        }

        @Override
        public IBuildingForClass isIncludeBootstrap(boolean isIncludeBootstrap) {
            if (isIncludeBootstrap) {
                this.includeBootstrap();
            }
            return this;
        }

        @Override
        public IBuildingForClass includeSubClasses() {
            this.isIncludeSubClasses = true;
            return this;
        }

        @Override
        public IBuildingForClass isIncludeSubClasses(boolean isIncludeSubClasses) {
            if (isIncludeSubClasses) {
                this.includeSubClasses();
            }
            return this;
        }

        @Override
        public IBuildingForClass withAccess(int access) {
            this.withAccess |= access;
            return this;
        }

        @Override
        public IBuildingForClass hasInterfaceTypes(String ... patterns) {
            this.hasInterfaceTypes.add(patterns);
            return this;
        }

        @Override
        public IBuildingForClass hasAnnotationTypes(String ... patterns) {
            this.hasAnnotationTypes.add(patterns);
            return this;
        }

        @Override
        public IBuildingForClass hasInterfaceTypes(Class<?> ... classes) {
            switch (EventWatchBuilder.this.patternType) {
                case REGEX: {
                    return this.hasInterfaceTypes(EventWatchBuilder.toRegexQuoteArray(GaStringUtils.getJavaClassNameArray(classes)));
                }
            }
            return this.hasInterfaceTypes(GaStringUtils.getJavaClassNameArray(classes));
        }

        @Override
        public IBuildingForClass hasAnnotationTypes(Class<?> ... classes) {
            switch (EventWatchBuilder.this.patternType) {
                case REGEX: {
                    return this.hasAnnotationTypes(EventWatchBuilder.toRegexQuoteArray(GaStringUtils.getJavaClassNameArray(classes)));
                }
            }
            return this.hasAnnotationTypes(GaStringUtils.getJavaClassNameArray(classes));
        }

        @Override
        public IBuildingForBehavior onBehavior(String pattern) {
            return GaCollectionUtils.add(this.bfBehaviors, new BuildingForBehavior(this, pattern));
        }

        @Override
        public IBuildingForBehavior onAnyBehavior() {
            switch (EventWatchBuilder.this.patternType) {
                case REGEX: {
                    return this.onBehavior(".*");
                }
            }
            return this.onBehavior("*");
        }
    }

    public static enum PatternType {
        WILDCARD,
        REGEX;

    }

    public static interface IBuildingForUnWatching {
        public IBuildingForUnWatching withProgress(ModuleEventWatcher.Progress var1);

        public void onUnWatched();
    }

    public static interface IBuildingForWatching {
        public IBuildingForWatching withProgress(ModuleEventWatcher.Progress var1);

        public IBuildingForWatching withCall();

        public IBuildingForWatching withLine();

        public EventWatcher onWatch(AdviceListener var1);

        public EventWatcher onWatch(EventListener var1, Event.Type ... var2);
    }

    public static interface IBuildingForBehavior {
        public IBuildingForBehavior withAccess(int var1);

        public IBuildingForBehavior withEmptyParameterTypes();

        public IBuildingForBehavior withParameterTypes(String ... var1);

        public IBuildingForBehavior withParameterTypes(Class<?> ... var1);

        public IBuildingForBehavior hasExceptionTypes(String ... var1);

        public IBuildingForBehavior hasExceptionTypes(Class<?> ... var1);

        public IBuildingForBehavior hasAnnotationTypes(String ... var1);

        public IBuildingForBehavior hasAnnotationTypes(Class<?> ... var1);

        public IBuildingForBehavior onBehavior(String var1);

        public IBuildingForClass onClass(String var1);

        public IBuildingForClass onClass(Class<?> var1);

        public IBuildingForClass onAnyClass();

        public IBuildingForWatching onWatching();

        public EventWatcher onWatch(AdviceListener var1);

        @Deprecated
        public EventWatcher onWatch(AdviceListener var1, Event.Type ... var2);

        public EventWatcher onWatch(EventListener var1, Event.Type ... var2);
    }

    public static interface IBuildingForClass {
        public IBuildingForClass includeBootstrap();

        public IBuildingForClass isIncludeBootstrap(boolean var1);

        public IBuildingForClass includeSubClasses();

        public IBuildingForClass isIncludeSubClasses(boolean var1);

        public IBuildingForClass withAccess(int var1);

        public IBuildingForClass hasInterfaceTypes(Class<?> ... var1);

        public IBuildingForClass hasInterfaceTypes(String ... var1);

        public IBuildingForClass hasAnnotationTypes(Class<?> ... var1);

        public IBuildingForClass hasAnnotationTypes(String ... var1);

        public IBuildingForBehavior onAnyBehavior();

        public IBuildingForBehavior onBehavior(String var1);
    }
}

