/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jvm.sandbox.api.listener.ext;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public interface Behavior {
    public Object invoke(Object var1, Object ... var2) throws IllegalAccessException, InvocationTargetException, InstantiationException;

    public boolean isAccessible();

    public void setAccessible(boolean var1);

    public String getName();

    public Class<?>[] getParameterTypes();

    public Annotation[] getAnnotations();

    public int getModifiers();

    public Class<?> getDeclaringClass();

    public Class<?> getReturnType();

    public Class<?>[] getExceptionTypes();

    public Annotation[] getDeclaredAnnotations();

    public AccessibleObject getTarget();

    public static class ConstructorImpl
    implements Behavior {
        private final Constructor<?> target;

        public ConstructorImpl(Constructor<?> target) {
            this.target = target;
        }

        @Override
        public Object invoke(Object obj, Object ... args) throws IllegalAccessException, InvocationTargetException, InstantiationException {
            return this.target.newInstance(args);
        }

        @Override
        public boolean isAccessible() {
            return this.target.isAccessible();
        }

        @Override
        public void setAccessible(boolean accessFlag) {
            this.target.setAccessible(accessFlag);
        }

        @Override
        public String getName() {
            return "<init>";
        }

        @Override
        public Class<?>[] getParameterTypes() {
            return this.target.getParameterTypes();
        }

        @Override
        public Annotation[] getAnnotations() {
            return this.target.getAnnotations();
        }

        @Override
        public int getModifiers() {
            return this.target.getModifiers();
        }

        @Override
        public Class<?> getDeclaringClass() {
            return this.target.getDeclaringClass();
        }

        @Override
        public Class<?> getReturnType() {
            return this.target.getDeclaringClass();
        }

        @Override
        public Class<?>[] getExceptionTypes() {
            return this.target.getExceptionTypes();
        }

        @Override
        public Annotation[] getDeclaredAnnotations() {
            return this.target.getDeclaredAnnotations();
        }

        @Override
        public AccessibleObject getTarget() {
            return this.target;
        }

        public int hashCode() {
            return this.target.hashCode();
        }

        public boolean equals(Object obj) {
            return this.target.equals(obj);
        }
    }

    public static class MethodImpl
    implements Behavior {
        private final Method target;

        public MethodImpl(Method target) {
            this.target = target;
        }

        @Override
        public Object invoke(Object obj, Object ... args) throws IllegalAccessException, InvocationTargetException, InstantiationException {
            return this.target.invoke(obj, args);
        }

        @Override
        public boolean isAccessible() {
            return this.target.isAccessible();
        }

        @Override
        public void setAccessible(boolean accessFlag) {
            this.target.setAccessible(accessFlag);
        }

        @Override
        public String getName() {
            return this.target.getName();
        }

        @Override
        public Class<?>[] getParameterTypes() {
            return this.target.getParameterTypes();
        }

        @Override
        public Annotation[] getAnnotations() {
            return this.target.getAnnotations();
        }

        @Override
        public int getModifiers() {
            return this.target.getModifiers();
        }

        @Override
        public Class<?> getDeclaringClass() {
            return this.target.getDeclaringClass();
        }

        @Override
        public Class<?> getReturnType() {
            return this.target.getReturnType();
        }

        @Override
        public Class<?>[] getExceptionTypes() {
            return this.target.getExceptionTypes();
        }

        @Override
        public Annotation[] getDeclaredAnnotations() {
            return this.target.getDeclaredAnnotations();
        }

        @Override
        public AccessibleObject getTarget() {
            return this.target;
        }

        public int hashCode() {
            return this.target.hashCode();
        }

        public boolean equals(Object obj) {
            return this.target.equals(obj);
        }
    }
}

