/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jvm.sandbox.api.listener.ext;

import com.alibaba.jvm.sandbox.api.event.BeforeEvent;
import com.alibaba.jvm.sandbox.api.event.CallBeforeEvent;
import com.alibaba.jvm.sandbox.api.event.CallReturnEvent;
import com.alibaba.jvm.sandbox.api.event.CallThrowsEvent;
import com.alibaba.jvm.sandbox.api.event.Event;
import com.alibaba.jvm.sandbox.api.event.InvokeEvent;
import com.alibaba.jvm.sandbox.api.event.LineEvent;
import com.alibaba.jvm.sandbox.api.event.ReturnEvent;
import com.alibaba.jvm.sandbox.api.event.ThrowsEvent;
import com.alibaba.jvm.sandbox.api.listener.EventListener;
import com.alibaba.jvm.sandbox.api.listener.ext.Advice;
import com.alibaba.jvm.sandbox.api.listener.ext.AdviceListener;
import com.alibaba.jvm.sandbox.api.listener.ext.Attachment;
import com.alibaba.jvm.sandbox.api.listener.ext.Behavior;
import com.alibaba.jvm.sandbox.api.util.BehaviorDescriptor;
import com.alibaba.jvm.sandbox.api.util.CacheGet;
import com.alibaba.jvm.sandbox.api.util.GaStringUtils;
import com.alibaba.jvm.sandbox.api.util.LazyGet;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Stack;

public class AdviceAdapterListener
implements EventListener {
    private final AdviceListener adviceListener;
    private final ThreadLocal<OpStack> opStackRef = new ThreadLocal<OpStack>(){

        @Override
        protected OpStack initialValue() {
            return new OpStack();
        }
    };
    private final CacheGet<BehaviorCacheKey, Behavior> toBehaviorCacheGet = new CacheGet<BehaviorCacheKey, Behavior>(){

        @Override
        protected Behavior load(BehaviorCacheKey key) {
            if ("<init>".equals(key.javaMethodName)) {
                for (Constructor<?> constructor : key.clazz.getDeclaredConstructors()) {
                    if (!key.javaMethodDesc.equals(new BehaviorDescriptor(constructor).getDescriptor())) continue;
                    return new Behavior.ConstructorImpl(constructor);
                }
            } else {
                for (Method method : key.clazz.getDeclaredMethods()) {
                    if (!key.javaMethodName.equals(method.getName()) || !key.javaMethodDesc.equals(new BehaviorDescriptor(method).getDescriptor())) continue;
                    return new Behavior.MethodImpl(method);
                }
            }
            return null;
        }
    };

    public AdviceAdapterListener(AdviceListener adviceListener) {
        this.adviceListener = adviceListener;
    }

    @Override
    public final void onEvent(Event event) throws Throwable {
        OpStack opStack = this.opStackRef.get();
        try {
            this.switchEvent(opStack, event);
        }
        finally {
            if (opStack.isEmpty()) {
                this.opStackRef.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchEvent(OpStack opStack, Event event) throws Throwable {
        switch (event.type) {
            case BEFORE: {
                Advice top;
                Advice parent;
                final BeforeEvent bEvent = (BeforeEvent)event;
                final ClassLoader loader = this.toClassLoader(bEvent.javaClassLoader);
                Advice advice = new Advice(bEvent.processId, bEvent.invokeId, new LazyGet<Behavior>(){
                    private final ClassLoader _loader;
                    private final String _javaClassName;
                    private final String _javaMethodName;
                    private final String _javaMethodDesc;
                    {
                        this._loader = loader;
                        this._javaClassName = bEvent.javaClassName;
                        this._javaMethodName = bEvent.javaMethodName;
                        this._javaMethodDesc = bEvent.javaMethodDesc;
                    }

                    @Override
                    protected Behavior initialValue() throws Throwable {
                        return AdviceAdapterListener.this.toBehavior(AdviceAdapterListener.this.toClass(this._loader, this._javaClassName), this._javaMethodName, this._javaMethodDesc);
                    }
                }, loader, bEvent.argumentArray, bEvent.target);
                if (opStack.isEmpty()) {
                    top = parent = advice;
                } else {
                    parent = opStack.peek().advice;
                    top = parent.getProcessTop();
                }
                advice.applyBefore(top, parent);
                this.opStackRef.get().pushForBegin(advice);
                this.adviceListener.before(advice);
                break;
            }
            case IMMEDIATELY_THROWS: 
            case IMMEDIATELY_RETURN: {
                InvokeEvent invokeEvent = (InvokeEvent)event;
                opStack.popByExpectInvokeId(invokeEvent.invokeId);
                break;
            }
            case RETURN: {
                ReturnEvent rEvent = (ReturnEvent)event;
                WrapAdvice wrapAdvice = opStack.popByExpectInvokeId(rEvent.invokeId);
                if (null == wrapAdvice) break;
                Advice advice = wrapAdvice.advice.applyReturn(rEvent.object);
                try {
                    this.adviceListener.afterReturning(advice);
                    break;
                }
                finally {
                    this.adviceListener.after(advice);
                }
            }
            case THROWS: {
                ThrowsEvent tEvent = (ThrowsEvent)event;
                WrapAdvice wrapAdvice = opStack.popByExpectInvokeId(tEvent.invokeId);
                if (null == wrapAdvice) break;
                Advice advice = wrapAdvice.advice.applyThrows(tEvent.throwable);
                try {
                    this.adviceListener.afterThrowing(advice);
                    break;
                }
                finally {
                    this.adviceListener.after(advice);
                }
            }
            case CALL_BEFORE: {
                CallBeforeEvent cbEvent = (CallBeforeEvent)event;
                WrapAdvice wrapAdvice = opStack.peekByExpectInvokeId(cbEvent.invokeId);
                if (null == wrapAdvice) {
                    return;
                }
                CallTarget target = new CallTarget(cbEvent.lineNumber, this.toJavaClassName(cbEvent.owner), cbEvent.name, cbEvent.desc);
                wrapAdvice.attach(target);
                this.adviceListener.beforeCall(wrapAdvice.advice, target.callLineNum, target.callJavaClassName, target.callJavaMethodName, target.callJavaMethodDesc);
                break;
            }
            case CALL_RETURN: {
                CallReturnEvent crEvent = (CallReturnEvent)event;
                WrapAdvice wrapAdvice = opStack.peekByExpectInvokeId(crEvent.invokeId);
                if (null == wrapAdvice) {
                    return;
                }
                CallTarget target = (CallTarget)wrapAdvice.attachment();
                if (null == target) {
                    return;
                }
                try {
                    this.adviceListener.afterCallReturning(wrapAdvice.advice, target.callLineNum, target.callJavaClassName, target.callJavaMethodName, target.callJavaMethodDesc);
                    break;
                }
                finally {
                    this.adviceListener.afterCall(wrapAdvice.advice, target.callLineNum, target.callJavaClassName, target.callJavaMethodName, target.callJavaMethodDesc, null);
                }
            }
            case CALL_THROWS: {
                CallThrowsEvent ctEvent = (CallThrowsEvent)event;
                WrapAdvice wrapAdvice = opStack.peekByExpectInvokeId(ctEvent.invokeId);
                if (null == wrapAdvice) {
                    return;
                }
                CallTarget target = (CallTarget)wrapAdvice.attachment();
                if (null == target) {
                    return;
                }
                try {
                    this.adviceListener.afterCallThrowing(wrapAdvice.advice, target.callLineNum, target.callJavaClassName, target.callJavaMethodName, target.callJavaMethodDesc, ctEvent.throwException);
                    break;
                }
                finally {
                    this.adviceListener.afterCall(wrapAdvice.advice, target.callLineNum, target.callJavaClassName, target.callJavaMethodName, target.callJavaMethodDesc, ctEvent.throwException);
                }
            }
            case LINE: {
                LineEvent lEvent = (LineEvent)event;
                WrapAdvice wrapAdvice = opStack.peekByExpectInvokeId(lEvent.invokeId);
                if (null == wrapAdvice) {
                    return;
                }
                this.adviceListener.beforeLine(wrapAdvice.advice, lEvent.lineNumber);
                break;
            }
        }
    }

    private String toJavaClassName(String internalClassName) {
        if (GaStringUtils.isEmpty(internalClassName)) {
            return internalClassName;
        }
        return internalClassName.replaceAll("/", ".");
    }

    private ClassLoader toClassLoader(ClassLoader loader) {
        return null == loader ? AdviceAdapterListener.class.getClassLoader() : loader;
    }

    private Class<?> toClass(ClassLoader loader, String javaClassName) throws ClassNotFoundException {
        return this.toClassLoader(loader).loadClass(javaClassName);
    }

    private Behavior toBehavior(Class<?> clazz, String javaMethodName, String javaMethodDesc) throws NoSuchMethodException {
        Behavior behavior = this.toBehaviorCacheGet.getFromCache(new BehaviorCacheKey(clazz, javaMethodName, javaMethodDesc));
        if (null == behavior) {
            throw new NoSuchMethodException(String.format("%s.%s(%s)", clazz.getName(), javaMethodName, javaMethodDesc));
        }
        return behavior;
    }

    private static class WrapAdvice
    implements Attachment {
        final Advice advice;
        Object attachment;

        WrapAdvice(Advice advice) {
            this.advice = advice;
        }

        @Override
        public void attach(Object attachment) {
            this.attachment = attachment;
        }

        @Override
        public <T> T attachment() {
            return (T)this.attachment;
        }
    }

    private static class CallTarget {
        final int callLineNum;
        final String callJavaClassName;
        final String callJavaMethodName;
        final String callJavaMethodDesc;

        CallTarget(int callLineNum, String callJavaClassName, String callJavaMethodName, String callJavaMethodDesc) {
            this.callLineNum = callLineNum;
            this.callJavaClassName = callJavaClassName;
            this.callJavaMethodName = callJavaMethodName;
            this.callJavaMethodDesc = callJavaMethodDesc;
        }
    }

    private static class BehaviorCacheKey {
        private final Class<?> clazz;
        private final String javaMethodName;
        private final String javaMethodDesc;

        private BehaviorCacheKey(Class<?> clazz, String javaMethodName, String javaMethodDesc) {
            this.clazz = clazz;
            this.javaMethodName = javaMethodName;
            this.javaMethodDesc = javaMethodDesc;
        }

        public int hashCode() {
            return this.clazz.hashCode() + this.javaMethodName.hashCode() + this.javaMethodDesc.hashCode();
        }

        public boolean equals(Object o) {
            if (null == o || !(o instanceof BehaviorCacheKey)) {
                return false;
            }
            BehaviorCacheKey key = (BehaviorCacheKey)o;
            return this.clazz.equals(key.clazz) && this.javaMethodName.equals(key.javaMethodName) && this.javaMethodDesc.equals(key.javaMethodDesc);
        }
    }

    private class OpStack {
        private final Stack<WrapAdvice> adviceStack = new Stack();

        private OpStack() {
        }

        boolean isEmpty() {
            return this.adviceStack.isEmpty();
        }

        WrapAdvice peek() {
            return this.adviceStack.peek();
        }

        void pushForBegin(Advice advice) {
            this.adviceStack.push(new WrapAdvice(advice));
        }

        WrapAdvice pop() {
            return !this.adviceStack.isEmpty() ? this.adviceStack.pop() : null;
        }

        WrapAdvice popByExpectInvokeId(int expectInvokeId) {
            return !this.adviceStack.isEmpty() && this.adviceStack.peek().advice.getInvokeId() == expectInvokeId ? this.adviceStack.pop() : null;
        }

        WrapAdvice peekByExpectInvokeId(int expectInvokeId) {
            return !this.adviceStack.isEmpty() && this.adviceStack.peek().advice.getInvokeId() == expectInvokeId ? this.adviceStack.peek() : null;
        }
    }
}

