/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jvm.sandbox.api.http.printer;

import com.alibaba.jvm.sandbox.api.http.printer.Printer;
import java.io.PrintWriter;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class ConcurrentLinkedQueuePrinter
implements Printer {
    private static final String NUL_STRING = new String(new byte[]{0});
    private final PrintWriter writer;
    private final ConcurrentLinkedQueue<String> writeQueue;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final int capacity;
    private final AtomicBoolean isBrokenRef = new AtomicBoolean(false);
    private final long delayStepTimeMs;
    private final long delayMaxTimeMs;
    private volatile long delayTimeMs;

    public ConcurrentLinkedQueuePrinter(PrintWriter writer, long delayStepTimeMs, long delayMaxTimeMs, int capacity) {
        this.writer = writer;
        this.writeQueue = new ConcurrentLinkedQueue();
        this.delayStepTimeMs = delayStepTimeMs;
        this.delayMaxTimeMs = delayMaxTimeMs;
        this.delayTimeMs = delayStepTimeMs;
        this.capacity = capacity;
    }

    public ConcurrentLinkedQueuePrinter(PrintWriter writer) {
        this(writer, 20L, 200L, Integer.MAX_VALUE);
    }

    private boolean isOverCapacity() {
        return this.writeQueue.size() >= this.capacity;
    }

    @Override
    public Printer print(String string) {
        if (!this.isOverCapacity()) {
            this.writeQueue.offer(string);
        }
        return this;
    }

    @Override
    public Printer println(String string) {
        if (!this.isOverCapacity()) {
            this.writeQueue.offer(string + "\n");
        }
        return this;
    }

    private void commit() {
        while (!this.writeQueue.isEmpty()) {
            String string = this.writeQueue.poll();
            if (null == string) {
                this.writer.print(NUL_STRING);
                continue;
            }
            this.writer.print(string);
        }
    }

    @Override
    public Printer flush() {
        this.commit();
        this.writer.flush();
        return this;
    }

    private long computeDelayTimeMs() {
        if (this.delayTimeMs >= this.delayMaxTimeMs) {
            return this.delayTimeMs;
        }
        long newDelayTime = this.delayTimeMs + this.delayStepTimeMs;
        this.delayTimeMs = Math.min(newDelayTime, this.delayMaxTimeMs);
        return this.delayTimeMs;
    }

    private void resetDelayTimeMs() {
        this.delayTimeMs = this.delayStepTimeMs;
    }

    private void delay() throws InterruptedException {
        if (this.delayMaxTimeMs <= 0L) {
            return;
        }
        this.lock.lock();
        try {
            this.condition.await(this.computeDelayTimeMs(), TimeUnit.MILLISECONDS);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Printer waitingForBroken() {
        this.waitingForBroken(0L, TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public boolean waitingForBroken(long time, TimeUnit unit) {
        long timeMs = unit.toMillis(time);
        boolean isTimeoutControl = timeMs > 0L;
        long startMs = isTimeoutControl ? System.currentTimeMillis() : 0L;
        try {
            while (!(this.writer.checkError() || this.isBrokenRef.get() || Thread.currentThread().isInterrupted())) {
                if (isTimeoutControl && System.currentTimeMillis() - startMs >= timeMs) {
                    return true;
                }
                if (this.writeQueue.isEmpty()) {
                    this.delay();
                    continue;
                }
                this.flush();
                this.resetDelayTimeMs();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.flush();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    @Override
    public Printer broken() {
        this.isBrokenRef.set(true);
        return this;
    }

    @Override
    public boolean isBroken() {
        return this.isBrokenRef.get();
    }

    @Override
    public void close() {
        this.writeQueue.clear();
        if (null != this.writer) {
            try {
                this.writer.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

