/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jvm.sandbox.api.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class BehaviorDescriptor {
    private final Type type;

    public BehaviorDescriptor(Constructor<?> constructor) {
        this.type = Type.getType(constructor);
    }

    public BehaviorDescriptor(Method method) {
        this.type = Type.getType(method);
    }

    public String getDescriptor() {
        return this.type.getDescriptor();
    }

    private static class Type {
        private static final int VOID = 0;
        private static final int BOOLEAN = 1;
        private static final int CHAR = 2;
        private static final int BYTE = 3;
        private static final int SHORT = 4;
        private static final int INT = 5;
        private static final int FLOAT = 6;
        private static final int LONG = 7;
        private static final int DOUBLE = 8;
        private static final int ARRAY = 9;
        private static final int OBJECT = 10;
        private static final int METHOD = 11;
        private static final Type VOID_TYPE = new Type(0, null, 0x56050000, 1);
        private static final Type BOOLEAN_TYPE = new Type(1, null, 1509950721, 1);
        private static final Type CHAR_TYPE = new Type(2, null, 1124075009, 1);
        private static final Type BYTE_TYPE = new Type(3, null, 1107297537, 1);
        private static final Type SHORT_TYPE = new Type(4, null, 1392510721, 1);
        private static final Type INT_TYPE = new Type(5, null, 1224736769, 1);
        private static final Type FLOAT_TYPE = new Type(6, null, 1174536705, 1);
        private static final Type LONG_TYPE = new Type(7, null, 1241579778, 1);
        private static final Type DOUBLE_TYPE = new Type(8, null, 1141048066, 1);
        private final int sort;
        private final char[] buf;
        private final int off;
        private final int len;

        private Type(int sort, char[] buf, int off, int len) {
            this.sort = sort;
            this.buf = buf;
            this.off = off;
            this.len = len;
        }

        private static Type getType(String typeDescriptor) {
            return Type.getType(typeDescriptor.toCharArray(), 0);
        }

        public static Type getType(Constructor<?> c) {
            return Type.getType(Type.getConstructorDescriptor(c));
        }

        public static Type getType(Method m) {
            return Type.getType(Type.getMethodDescriptor(m));
        }

        private static Type getType(char[] buf, int off) {
            switch (buf[off]) {
                case 'V': {
                    return VOID_TYPE;
                }
                case 'Z': {
                    return BOOLEAN_TYPE;
                }
                case 'C': {
                    return CHAR_TYPE;
                }
                case 'B': {
                    return BYTE_TYPE;
                }
                case 'S': {
                    return SHORT_TYPE;
                }
                case 'I': {
                    return INT_TYPE;
                }
                case 'F': {
                    return FLOAT_TYPE;
                }
                case 'J': {
                    return LONG_TYPE;
                }
                case 'D': {
                    return DOUBLE_TYPE;
                }
                case '[': {
                    int len = 1;
                    while (buf[off + len] == '[') {
                        ++len;
                    }
                    if (buf[off + len] == 'L') {
                        ++len;
                        while (buf[off + len] != ';') {
                            ++len;
                        }
                    }
                    return new Type(9, buf, off, len + 1);
                }
                case 'L': {
                    int len = 1;
                    while (buf[off + len] != ';') {
                        ++len;
                    }
                    return new Type(10, buf, off + 1, len - 1);
                }
            }
            return new Type(11, buf, off, buf.length - off);
        }

        public String getDescriptor() {
            StringBuilder buf = new StringBuilder();
            this.getDescriptor(buf);
            return buf.toString();
        }

        private void getDescriptor(StringBuilder buf) {
            if (this.buf == null) {
                buf.append((char)((this.off & 0xFF000000) >>> 24));
            } else if (this.sort == 10) {
                buf.append('L');
                buf.append(this.buf, this.off, this.len);
                buf.append(';');
            } else {
                buf.append(this.buf, this.off, this.len);
            }
        }

        private static String getConstructorDescriptor(Constructor<?> c) {
            Class<?>[] parameters = c.getParameterTypes();
            StringBuilder buf = new StringBuilder();
            buf.append('(');
            for (Class<?> parameter : parameters) {
                Type.getDescriptor(buf, parameter);
            }
            return buf.append(")V").toString();
        }

        private static String getMethodDescriptor(Method m) {
            Class<?>[] parameters = m.getParameterTypes();
            StringBuilder buf = new StringBuilder();
            buf.append('(');
            for (Class<?> parameter : parameters) {
                Type.getDescriptor(buf, parameter);
            }
            buf.append(')');
            Type.getDescriptor(buf, m.getReturnType());
            return buf.toString();
        }

        private static void getDescriptor(StringBuilder buf, Class<?> c) {
            Class<?> d = c;
            while (true) {
                if (d.isPrimitive()) {
                    int car = d == Integer.TYPE ? 73 : (d == Void.TYPE ? 86 : (d == Boolean.TYPE ? 90 : (d == Byte.TYPE ? 66 : (d == Character.TYPE ? 67 : (d == Short.TYPE ? 83 : (d == Double.TYPE ? 68 : (d == Float.TYPE ? 70 : 74)))))));
                    buf.append((char)car);
                    return;
                }
                if (!d.isArray()) break;
                buf.append('[');
                d = d.getComponentType();
            }
            buf.append('L');
            String name = d.getName();
            int len = name.length();
            for (int i = 0; i < len; ++i) {
                char car = name.charAt(i);
                buf.append(car == '.' ? (char)'/' : (char)car);
            }
            buf.append(';');
        }
    }
}

