/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.util.cache;

import java.security.InvalidParameterException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.postgresql.util.FunctionWithSQLException;

public class Cache<K, V> {
    Map<K, Item> cache = new HashMap<K, Item>();
    FunctionWithSQLException<K, V> builder;
    private long ttl;

    public Cache() {
        this(null);
    }

    public Cache(FunctionWithSQLException<K, V> builder) {
        this(-1L, builder);
    }

    public Cache(long ttl, FunctionWithSQLException<K, V> builder) {
        this.ttl = ttl;
        this.builder = builder;
    }

    public void setBuilder(FunctionWithSQLException<K, V> builder) {
        this.builder = builder;
    }

    public void setTtl(long ttl) {
        this.ttl = ttl;
    }

    public V get(K key) throws SQLException {
        return this.get(key, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key, FunctionWithSQLException<K, V> builder) throws SQLException {
        Item item = this.cache.get(key);
        V value = null;
        if (null == item) {
            Cache cache = this;
            synchronized (cache) {
                item = this.cache.get(key);
                value = null == item ? (V)this.remoteGet(key, builder) : (item.isExpire() ? (V)this.remoteGet(key, item, builder) : (V)item.get());
            }
        } else if (item.isExpire()) {
            Cache cache = this;
            synchronized (cache) {
                item = this.cache.get(key);
                value = null == item ? (V)this.remoteGet(key, builder) : (item.isExpire() ? (V)this.remoteGet(key, item, builder) : (V)item.get());
            }
        } else {
            value = item.get();
        }
        return value;
    }

    public synchronized void remove(K key) {
        this.cache.remove(key);
    }

    public synchronized V remoteGet(K key, FunctionWithSQLException<K, V> inputBuilder) throws SQLException {
        return this.remoteGet(key, null, inputBuilder);
    }

    public synchronized V remoteGet(K key, Item oldItem, FunctionWithSQLException<K, V> inputBuilder) throws SQLException {
        V value;
        if (inputBuilder == null && this.builder == null) {
            throw new InvalidParameterException("no value builder function");
        }
        V v = value = inputBuilder == null ? this.builder.apply(key) : inputBuilder.apply(key);
        if (value != null) {
            if (oldItem == null || !oldItem.get().equals(value)) {
                HashMap<K, Item> temp = new HashMap<K, Item>(this.cache);
                temp.put(key, new Item(value));
                this.cache = temp;
            } else {
                oldItem.flushCreateTime();
                value = oldItem.get();
            }
        }
        return value;
    }

    class Item {
        V value;
        long createTime;

        Item(V value) {
            this.value = value;
            this.createTime = System.currentTimeMillis();
        }

        public V get() {
            return this.value;
        }

        public boolean isExpire() {
            if (Cache.this.ttl < 1L) {
                return false;
            }
            return this.createTime < System.currentTimeMillis() - Cache.this.ttl;
        }

        public void flushCreateTime() {
            this.createTime = System.currentTimeMillis();
        }
    }
}

