/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.util;

import java.util.HashMap;
import java.util.Map;

public class IdentifierUtil {
    static final int UNRESERVED_KEYWORD = 0;
    static final int RESERVED_KEYWORD = 1;
    static final int COL_NAME_KEYWORD = 2;
    static final int TYPE_FUNC_NAME_KEYWORD = 3;
    static Map<String, Integer> keywordMap = new HashMap<String, Integer>();

    public static String quoteIdentifier(String name) {
        return IdentifierUtil.quoteIdentifier(name, false);
    }

    public static String quoteIdentifier(String name, boolean isCaseSensitive) {
        boolean hasLowercase = false;
        boolean hasUppercase = false;
        boolean safe = true;
        int nquotes = 0;
        if (name == null) {
            return name;
        }
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            char ch = name.charAt(i);
            if (ch >= 'a' && ch <= 'z') {
                hasLowercase = true;
                continue;
            }
            if (ch >= 'A' && ch <= 'Z') {
                hasUppercase = true;
                continue;
            }
            if (ch == '_') continue;
            if (ch >= '0' && ch <= '9') {
                if (i != 0) continue;
                safe = false;
                continue;
            }
            safe = false;
            if (ch != '\"') continue;
            ++nquotes;
        }
        if (isCaseSensitive && hasUppercase) {
            safe = false;
        }
        if (safe) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < len; ++i) {
                char ch = name.charAt(i);
                if (ch >= 'A' && ch <= 'Z') {
                    ch = (char)(ch + 32);
                }
                sb.append(ch);
            }
            String lowerName = sb.toString();
            Integer r = keywordMap.get(lowerName);
            if (r != null && r != 0) {
                safe = false;
            }
        }
        if (safe) {
            return name;
        }
        StringBuffer sb = new StringBuffer();
        sb.append('\"');
        for (int i = 0; i < len; ++i) {
            char ch = name.charAt(i);
            if (ch == '\"') {
                sb.append('\"');
            }
            sb.append(ch);
        }
        sb.append('\"');
        return sb.toString();
    }

    static {
        keywordMap.put("abort", 0);
        keywordMap.put("absolute", 0);
        keywordMap.put("access", 0);
        keywordMap.put("action", 0);
        keywordMap.put("add", 0);
        keywordMap.put("admin", 0);
        keywordMap.put("after", 0);
        keywordMap.put("aggregate", 0);
        keywordMap.put("all", 1);
        keywordMap.put("also", 0);
        keywordMap.put("alter", 0);
        keywordMap.put("always", 0);
        keywordMap.put("analyse", 1);
        keywordMap.put("analyze", 1);
        keywordMap.put("and", 1);
        keywordMap.put("any", 1);
        keywordMap.put("array", 1);
        keywordMap.put("as", 1);
        keywordMap.put("asc", 1);
        keywordMap.put("assertion", 0);
        keywordMap.put("assignment", 0);
        keywordMap.put("asymmetric", 1);
        keywordMap.put("at", 0);
        keywordMap.put("attach", 0);
        keywordMap.put("attribute", 0);
        keywordMap.put("authorization", 3);
        keywordMap.put("backward", 0);
        keywordMap.put("before", 0);
        keywordMap.put("begin", 0);
        keywordMap.put("between", 2);
        keywordMap.put("bigint", 2);
        keywordMap.put("binary", 3);
        keywordMap.put("bit", 2);
        keywordMap.put("boolean", 2);
        keywordMap.put("both", 1);
        keywordMap.put("by", 0);
        keywordMap.put("cache", 0);
        keywordMap.put("call", 0);
        keywordMap.put("called", 0);
        keywordMap.put("cascade", 0);
        keywordMap.put("cascaded", 0);
        keywordMap.put("case", 1);
        keywordMap.put("cast", 1);
        keywordMap.put("catalog", 0);
        keywordMap.put("chain", 0);
        keywordMap.put("char", 2);
        keywordMap.put("character", 2);
        keywordMap.put("characteristics", 0);
        keywordMap.put("check", 1);
        keywordMap.put("checkpoint", 0);
        keywordMap.put("class", 0);
        keywordMap.put("close", 0);
        keywordMap.put("cluster", 0);
        keywordMap.put("coalesce", 2);
        keywordMap.put("collate", 1);
        keywordMap.put("collation", 3);
        keywordMap.put("column", 1);
        keywordMap.put("columns", 0);
        keywordMap.put("comment", 0);
        keywordMap.put("comments", 0);
        keywordMap.put("commit", 0);
        keywordMap.put("committed", 0);
        keywordMap.put("concurrently", 3);
        keywordMap.put("configuration", 0);
        keywordMap.put("conflict", 0);
        keywordMap.put("connection", 0);
        keywordMap.put("constraint", 1);
        keywordMap.put("constraints", 0);
        keywordMap.put("content", 0);
        keywordMap.put("continue", 0);
        keywordMap.put("conversion", 0);
        keywordMap.put("copy", 0);
        keywordMap.put("cost", 0);
        keywordMap.put("create", 1);
        keywordMap.put("cross", 3);
        keywordMap.put("csv", 0);
        keywordMap.put("cube", 0);
        keywordMap.put("current", 0);
        keywordMap.put("current_catalog", 1);
        keywordMap.put("current_date", 1);
        keywordMap.put("current_role", 1);
        keywordMap.put("current_schema", 3);
        keywordMap.put("current_time", 1);
        keywordMap.put("current_timestamp", 1);
        keywordMap.put("current_user", 1);
        keywordMap.put("cursor", 0);
        keywordMap.put("cycle", 0);
        keywordMap.put("data", 0);
        keywordMap.put("database", 0);
        keywordMap.put("day", 0);
        keywordMap.put("deallocate", 0);
        keywordMap.put("dec", 2);
        keywordMap.put("decimal", 2);
        keywordMap.put("declare", 0);
        keywordMap.put("default", 1);
        keywordMap.put("defaults", 0);
        keywordMap.put("deferrable", 1);
        keywordMap.put("deferred", 0);
        keywordMap.put("definer", 0);
        keywordMap.put("delete", 0);
        keywordMap.put("delimiter", 0);
        keywordMap.put("delimiters", 0);
        keywordMap.put("depends", 0);
        keywordMap.put("desc", 1);
        keywordMap.put("detach", 0);
        keywordMap.put("dictionary", 0);
        keywordMap.put("disable", 0);
        keywordMap.put("discard", 0);
        keywordMap.put("distinct", 1);
        keywordMap.put("do", 1);
        keywordMap.put("document", 0);
        keywordMap.put("domain", 0);
        keywordMap.put("double", 0);
        keywordMap.put("drop", 0);
        keywordMap.put("each", 0);
        keywordMap.put("else", 1);
        keywordMap.put("enable", 0);
        keywordMap.put("encoding", 0);
        keywordMap.put("encrypted", 0);
        keywordMap.put("end", 1);
        keywordMap.put("enum", 0);
        keywordMap.put("escape", 0);
        keywordMap.put("event", 0);
        keywordMap.put("except", 1);
        keywordMap.put("exclude", 0);
        keywordMap.put("excluding", 0);
        keywordMap.put("exclusive", 0);
        keywordMap.put("execute", 0);
        keywordMap.put("exists", 2);
        keywordMap.put("explain", 0);
        keywordMap.put("extension", 0);
        keywordMap.put("external", 0);
        keywordMap.put("extract", 2);
        keywordMap.put("false", 1);
        keywordMap.put("family", 0);
        keywordMap.put("fetch", 1);
        keywordMap.put("filter", 0);
        keywordMap.put("first", 0);
        keywordMap.put("float", 2);
        keywordMap.put("following", 0);
        keywordMap.put("for", 1);
        keywordMap.put("force", 0);
        keywordMap.put("foreign", 1);
        keywordMap.put("forward", 0);
        keywordMap.put("freeze", 3);
        keywordMap.put("from", 1);
        keywordMap.put("full", 3);
        keywordMap.put("function", 0);
        keywordMap.put("functions", 0);
        keywordMap.put("generated", 0);
        keywordMap.put("global", 0);
        keywordMap.put("grant", 1);
        keywordMap.put("granted", 0);
        keywordMap.put("greatest", 2);
        keywordMap.put("group", 1);
        keywordMap.put("grouping", 2);
        keywordMap.put("groups", 0);
        keywordMap.put("handler", 0);
        keywordMap.put("having", 1);
        keywordMap.put("header", 0);
        keywordMap.put("hold", 0);
        keywordMap.put("hour", 0);
        keywordMap.put("identity", 0);
        keywordMap.put("if", 0);
        keywordMap.put("ilike", 3);
        keywordMap.put("immediate", 0);
        keywordMap.put("immutable", 0);
        keywordMap.put("implicit", 0);
        keywordMap.put("import", 0);
        keywordMap.put("in", 1);
        keywordMap.put("include", 0);
        keywordMap.put("including", 0);
        keywordMap.put("increment", 0);
        keywordMap.put("index", 0);
        keywordMap.put("indexes", 0);
        keywordMap.put("inherit", 0);
        keywordMap.put("inherits", 0);
        keywordMap.put("initially", 1);
        keywordMap.put("inline", 0);
        keywordMap.put("inner", 3);
        keywordMap.put("inout", 2);
        keywordMap.put("input", 0);
        keywordMap.put("insensitive", 0);
        keywordMap.put("insert", 0);
        keywordMap.put("instead", 0);
        keywordMap.put("int", 2);
        keywordMap.put("integer", 2);
        keywordMap.put("intersect", 1);
        keywordMap.put("interval", 2);
        keywordMap.put("into", 1);
        keywordMap.put("invoker", 0);
        keywordMap.put("is", 3);
        keywordMap.put("isnull", 3);
        keywordMap.put("isolation", 0);
        keywordMap.put("join", 3);
        keywordMap.put("key", 0);
        keywordMap.put("label", 0);
        keywordMap.put("language", 0);
        keywordMap.put("large", 0);
        keywordMap.put("last", 0);
        keywordMap.put("lateral", 1);
        keywordMap.put("leading", 1);
        keywordMap.put("leakproof", 0);
        keywordMap.put("least", 2);
        keywordMap.put("left", 3);
        keywordMap.put("level", 0);
        keywordMap.put("like", 3);
        keywordMap.put("limit", 1);
        keywordMap.put("listen", 0);
        keywordMap.put("load", 0);
        keywordMap.put("local", 0);
        keywordMap.put("localtime", 1);
        keywordMap.put("localtimestamp", 1);
        keywordMap.put("location", 0);
        keywordMap.put("lock", 0);
        keywordMap.put("locked", 0);
        keywordMap.put("logged", 0);
        keywordMap.put("mapping", 0);
        keywordMap.put("match", 0);
        keywordMap.put("materialized", 0);
        keywordMap.put("maxvalue", 0);
        keywordMap.put("method", 0);
        keywordMap.put("minute", 0);
        keywordMap.put("minvalue", 0);
        keywordMap.put("mode", 0);
        keywordMap.put("month", 0);
        keywordMap.put("move", 0);
        keywordMap.put("name", 0);
        keywordMap.put("names", 0);
        keywordMap.put("national", 2);
        keywordMap.put("natural", 3);
        keywordMap.put("nchar", 2);
        keywordMap.put("new", 0);
        keywordMap.put("next", 0);
        keywordMap.put("no", 0);
        keywordMap.put("none", 2);
        keywordMap.put("not", 1);
        keywordMap.put("nothing", 0);
        keywordMap.put("notify", 0);
        keywordMap.put("notnull", 3);
        keywordMap.put("nowait", 0);
        keywordMap.put("null", 1);
        keywordMap.put("nullif", 2);
        keywordMap.put("nulls", 0);
        keywordMap.put("numeric", 2);
        keywordMap.put("object", 0);
        keywordMap.put("of", 0);
        keywordMap.put("off", 0);
        keywordMap.put("offset", 1);
        keywordMap.put("oids", 0);
        keywordMap.put("old", 0);
        keywordMap.put("on", 1);
        keywordMap.put("only", 1);
        keywordMap.put("operator", 0);
        keywordMap.put("option", 0);
        keywordMap.put("options", 0);
        keywordMap.put("or", 1);
        keywordMap.put("order", 1);
        keywordMap.put("ordinality", 0);
        keywordMap.put("others", 0);
        keywordMap.put("out", 2);
        keywordMap.put("outer", 3);
        keywordMap.put("over", 0);
        keywordMap.put("overlaps", 3);
        keywordMap.put("overlay", 2);
        keywordMap.put("overriding", 0);
        keywordMap.put("owned", 0);
        keywordMap.put("owner", 0);
        keywordMap.put("parallel", 0);
        keywordMap.put("parser", 0);
        keywordMap.put("partial", 0);
        keywordMap.put("partition", 0);
        keywordMap.put("passing", 0);
        keywordMap.put("password", 0);
        keywordMap.put("placing", 1);
        keywordMap.put("plans", 0);
        keywordMap.put("policy", 0);
        keywordMap.put("position", 2);
        keywordMap.put("preceding", 0);
        keywordMap.put("precision", 2);
        keywordMap.put("prepare", 0);
        keywordMap.put("prepared", 0);
        keywordMap.put("preserve", 0);
        keywordMap.put("primary", 1);
        keywordMap.put("prior", 0);
        keywordMap.put("privileges", 0);
        keywordMap.put("procedural", 0);
        keywordMap.put("procedure", 0);
        keywordMap.put("procedures", 0);
        keywordMap.put("program", 0);
        keywordMap.put("publication", 0);
        keywordMap.put("quote", 0);
        keywordMap.put("range", 0);
        keywordMap.put("read", 0);
        keywordMap.put("real", 2);
        keywordMap.put("reassign", 0);
        keywordMap.put("recheck", 0);
        keywordMap.put("recursive", 0);
        keywordMap.put("ref", 0);
        keywordMap.put("references", 1);
        keywordMap.put("referencing", 0);
        keywordMap.put("refresh", 0);
        keywordMap.put("reindex", 0);
        keywordMap.put("relative", 0);
        keywordMap.put("release", 0);
        keywordMap.put("rename", 0);
        keywordMap.put("repeatable", 0);
        keywordMap.put("replace", 0);
        keywordMap.put("replica", 0);
        keywordMap.put("reset", 0);
        keywordMap.put("restart", 0);
        keywordMap.put("restrict", 0);
        keywordMap.put("returning", 1);
        keywordMap.put("returns", 0);
        keywordMap.put("revoke", 0);
        keywordMap.put("right", 3);
        keywordMap.put("role", 0);
        keywordMap.put("rollback", 0);
        keywordMap.put("rollup", 0);
        keywordMap.put("routine", 0);
        keywordMap.put("routines", 0);
        keywordMap.put("row", 2);
        keywordMap.put("rows", 0);
        keywordMap.put("rule", 0);
        keywordMap.put("savepoint", 0);
        keywordMap.put("schema", 0);
        keywordMap.put("schemas", 0);
        keywordMap.put("scroll", 0);
        keywordMap.put("search", 0);
        keywordMap.put("second", 0);
        keywordMap.put("security", 0);
        keywordMap.put("select", 1);
        keywordMap.put("sequence", 0);
        keywordMap.put("sequences", 0);
        keywordMap.put("serializable", 0);
        keywordMap.put("server", 0);
        keywordMap.put("session", 0);
        keywordMap.put("session_user", 1);
        keywordMap.put("set", 0);
        keywordMap.put("setof", 2);
        keywordMap.put("sets", 0);
        keywordMap.put("share", 0);
        keywordMap.put("show", 0);
        keywordMap.put("similar", 3);
        keywordMap.put("simple", 0);
        keywordMap.put("skip", 0);
        keywordMap.put("smallint", 2);
        keywordMap.put("snapshot", 0);
        keywordMap.put("some", 1);
        keywordMap.put("sql", 0);
        keywordMap.put("stable", 0);
        keywordMap.put("standalone", 0);
        keywordMap.put("start", 0);
        keywordMap.put("statement", 0);
        keywordMap.put("statistics", 0);
        keywordMap.put("stdin", 0);
        keywordMap.put("stdout", 0);
        keywordMap.put("storage", 0);
        keywordMap.put("strict", 0);
        keywordMap.put("strip", 0);
        keywordMap.put("subscription", 0);
        keywordMap.put("substring", 2);
        keywordMap.put("symmetric", 1);
        keywordMap.put("sysid", 0);
        keywordMap.put("system", 0);
        keywordMap.put("table", 1);
        keywordMap.put("tables", 0);
        keywordMap.put("tablesample", 3);
        keywordMap.put("tablespace", 0);
        keywordMap.put("temp", 0);
        keywordMap.put("template", 0);
        keywordMap.put("temporary", 0);
        keywordMap.put("text", 0);
        keywordMap.put("then", 1);
        keywordMap.put("ties", 0);
        keywordMap.put("time", 2);
        keywordMap.put("timestamp", 2);
        keywordMap.put("to", 1);
        keywordMap.put("trailing", 1);
        keywordMap.put("transaction", 0);
        keywordMap.put("transform", 0);
        keywordMap.put("treat", 2);
        keywordMap.put("trigger", 0);
        keywordMap.put("trim", 2);
        keywordMap.put("true", 1);
        keywordMap.put("truncate", 0);
        keywordMap.put("trusted", 0);
        keywordMap.put("type", 0);
        keywordMap.put("types", 0);
        keywordMap.put("unbounded", 0);
        keywordMap.put("uncommitted", 0);
        keywordMap.put("unencrypted", 0);
        keywordMap.put("union", 1);
        keywordMap.put("unique", 1);
        keywordMap.put("unknown", 0);
        keywordMap.put("unlisten", 0);
        keywordMap.put("unlogged", 0);
        keywordMap.put("until", 0);
        keywordMap.put("update", 0);
        keywordMap.put("user", 1);
        keywordMap.put("using", 1);
        keywordMap.put("vacuum", 0);
        keywordMap.put("valid", 0);
        keywordMap.put("validate", 0);
        keywordMap.put("validator", 0);
        keywordMap.put("value", 0);
        keywordMap.put("values", 2);
        keywordMap.put("varchar", 2);
        keywordMap.put("variadic", 1);
        keywordMap.put("varying", 0);
        keywordMap.put("verbose", 3);
        keywordMap.put("version", 0);
        keywordMap.put("view", 0);
        keywordMap.put("views", 0);
        keywordMap.put("volatile", 0);
        keywordMap.put("when", 1);
        keywordMap.put("where", 1);
        keywordMap.put("whitespace", 0);
        keywordMap.put("window", 1);
        keywordMap.put("with", 1);
        keywordMap.put("within", 0);
        keywordMap.put("without", 0);
        keywordMap.put("work", 0);
        keywordMap.put("wrapper", 0);
        keywordMap.put("write", 0);
        keywordMap.put("xml", 0);
        keywordMap.put("xmlattributes", 2);
        keywordMap.put("xmlconcat", 2);
        keywordMap.put("xmlelement", 2);
        keywordMap.put("xmlexists", 2);
        keywordMap.put("xmlforest", 2);
        keywordMap.put("xmlnamespaces", 2);
        keywordMap.put("xmlparse", 2);
        keywordMap.put("xmlpi", 2);
        keywordMap.put("xmlroot", 2);
        keywordMap.put("xmlserialize", 2);
        keywordMap.put("xmltable", 2);
        keywordMap.put("year", 0);
        keywordMap.put("yes", 0);
        keywordMap.put("zone", 0);
    }
}

