/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.postgresql.util.InvalidIdentifierException;

public class TableName {
    public static final String DEFAULT_SCHEMA_NAME = "public";
    private static final byte[] LOCK = new byte[0];
    private static Map<String, TableName> tableCache2 = new HashMap<String, TableName>();
    String schemaName;
    String tableName;
    String fullName;
    static final Pattern IDENTIFIER_PATTERN = Pattern.compile("^[^\"\\s\\d\\-;][^\"\\s\\-;]*$");

    private TableName(String schemaName, String tableName, String fullName) {
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.fullName = fullName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public static TableName valueOf(String schemaName, String tableName) throws InvalidIdentifierException {
        if (schemaName == null || schemaName.length() < 1) {
            schemaName = DEFAULT_SCHEMA_NAME;
        }
        return TableName.valueOf(schemaName + "." + tableName);
    }

    public static String parseIdentifier(String identifier) {
        if (identifier.startsWith("\"")) {
            if (identifier.endsWith("\"") && identifier.length() > 2) {
                StringBuilder sb = new StringBuilder();
                boolean isQuota = false;
                for (int i = 1; i < identifier.length() - 1; ++i) {
                    char c = identifier.charAt(i);
                    if ('\"' == c) {
                        if (isQuota) {
                            sb.append(c);
                        }
                        isQuota = !isQuota;
                        continue;
                    }
                    if (isQuota) {
                        throw new InvalidIdentifierException(identifier);
                    }
                    sb.append(c);
                }
                if (isQuota) {
                    throw new InvalidIdentifierException(identifier);
                }
                return sb.toString();
            }
        } else if (IDENTIFIER_PATTERN.matcher(identifier).find()) {
            return identifier.toLowerCase();
        }
        throw new InvalidIdentifierException(identifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TableName valueOf(String name) throws InvalidIdentifierException {
        TableName tableName = tableCache2.get(name);
        if (tableName != null) return tableName;
        byte[] byArray = LOCK;
        synchronized (LOCK) {
            char c;
            int i;
            String qualifierName;
            String schemaName;
            tableName = tableCache2.get(name);
            if (tableName != null) return tableName;
            String[] schemaAndTableName = name.split("\\.");
            if (schemaAndTableName.length < 2) {
                schemaName = DEFAULT_SCHEMA_NAME;
                qualifierName = schemaAndTableName[0];
            } else {
                schemaName = schemaAndTableName[0];
                qualifierName = schemaAndTableName[1];
            }
            String parsedSchemaName = TableName.parseIdentifier(schemaName);
            String parsedTableName = TableName.parseIdentifier(qualifierName);
            StringBuilder sb = new StringBuilder();
            sb.append("\"");
            for (i = 0; i < parsedSchemaName.length(); ++i) {
                c = parsedSchemaName.charAt(i);
                if (c == '\"') {
                    sb.append(c);
                }
                sb.append(c);
            }
            sb.append("\".\"");
            for (i = 0; i < parsedTableName.length(); ++i) {
                c = parsedTableName.charAt(i);
                if (c == '\"') {
                    sb.append(c);
                }
                sb.append(c);
            }
            sb.append("\"");
            String parsedFullName = sb.toString();
            HashMap<String, TableName> temp = new HashMap<String, TableName>(tableCache2);
            tableName = tableCache2.get(parsedFullName);
            if (tableName == null) {
                tableName = new TableName(parsedSchemaName, parsedTableName, parsedFullName);
                temp.put(parsedFullName, tableName);
            }
            temp.put(name, tableName);
            tableCache2 = temp;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return tableName;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableName tableName1 = (TableName)o;
        return Objects.equals(this.schemaName, tableName1.schemaName) && Objects.equals(this.tableName, tableName1.tableName);
    }

    public int hashCode() {
        return Objects.hash(this.schemaName, this.tableName);
    }

    public String toString() {
        return this.fullName;
    }
}

