/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fescar.rm.tcc.remoting.parser;

import com.alibaba.fescar.common.exception.FrameworkException;
import com.alibaba.fescar.common.loader.EnhancedServiceLoader;
import com.alibaba.fescar.common.util.CollectionUtils;
import com.alibaba.fescar.common.util.ReflectionUtil;
import com.alibaba.fescar.core.model.Resource;
import com.alibaba.fescar.rm.DefaultResourceManager;
import com.alibaba.fescar.rm.tcc.TCCResource;
import com.alibaba.fescar.rm.tcc.api.BusinessActionContext;
import com.alibaba.fescar.rm.tcc.api.TwoPhaseBusinessAction;
import com.alibaba.fescar.rm.tcc.remoting.RemotingDesc;
import com.alibaba.fescar.rm.tcc.remoting.RemotingParser;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultRemotingParser {
    protected static List<RemotingParser> allRemotingParsers = new ArrayList<RemotingParser>();
    protected static Map<String, RemotingDesc> remotingServiceMap = new ConcurrentHashMap<String, RemotingDesc>();

    public static DefaultRemotingParser get() {
        return SingletonHolder.INSTANCE;
    }

    protected DefaultRemotingParser() {
        this.initRemotingParser();
    }

    protected void initRemotingParser() {
        List remotingParsers = EnhancedServiceLoader.loadAll(RemotingParser.class);
        if (CollectionUtils.isNotEmpty((Collection)remotingParsers)) {
            allRemotingParsers.addAll(remotingParsers);
        }
    }

    public boolean isRemoting(Object bean, String beanName) {
        for (RemotingParser remotingParser : allRemotingParsers) {
            if (!remotingParser.isRemoting(bean, beanName)) continue;
            return true;
        }
        return false;
    }

    public boolean isReference(Object bean, String beanName) {
        for (RemotingParser remotingParser : allRemotingParsers) {
            if (!remotingParser.isReference(bean, beanName)) continue;
            return true;
        }
        return false;
    }

    public boolean isService(Object bean, String beanName) {
        for (RemotingParser remotingParser : allRemotingParsers) {
            if (!remotingParser.isService(bean, beanName)) continue;
            return true;
        }
        return false;
    }

    public RemotingDesc getServiceDesc(Object bean, String beanName) {
        ArrayList<RemotingDesc> ret = new ArrayList<RemotingDesc>();
        for (RemotingParser remotingParser : allRemotingParsers) {
            RemotingDesc s = remotingParser.getServiceDesc(bean, beanName);
            if (s == null) continue;
            ret.add(s);
        }
        if (ret.size() == 1) {
            return (RemotingDesc)ret.get(0);
        }
        if (ret.size() > 1) {
            throw new FrameworkException("More than one RemotingParser for bean:" + beanName);
        }
        return null;
    }

    public RemotingDesc parserRemotingServiceInfo(Object bean, String beanName) {
        RemotingDesc remotingBeanDesc = this.getServiceDesc(bean, beanName);
        if (remotingBeanDesc == null) {
            return null;
        }
        remotingServiceMap.put(beanName, remotingBeanDesc);
        Class<?> interfaceClass = remotingBeanDesc.getInterfaceClass();
        Method[] methods = interfaceClass.getMethods();
        if (this.isService(bean, beanName)) {
            try {
                Object targetBean = remotingBeanDesc.getTargetBean();
                for (Method m : methods) {
                    TwoPhaseBusinessAction twoPhaseBusinessAction = m.getAnnotation(TwoPhaseBusinessAction.class);
                    if (twoPhaseBusinessAction == null) continue;
                    TCCResource tccResource = new TCCResource();
                    tccResource.setActionName(twoPhaseBusinessAction.name());
                    tccResource.setTargetBean(targetBean);
                    tccResource.setPrepareMethod(m);
                    tccResource.setCommitMethodName(twoPhaseBusinessAction.commitMethod());
                    tccResource.setCommitMethod(ReflectionUtil.getMethod(interfaceClass, (String)twoPhaseBusinessAction.commitMethod(), (Class[])new Class[]{BusinessActionContext.class}));
                    tccResource.setRollbackMethodName(twoPhaseBusinessAction.rollbackMethod());
                    tccResource.setRollbackMethod(ReflectionUtil.getMethod(interfaceClass, (String)twoPhaseBusinessAction.rollbackMethod(), (Class[])new Class[]{BusinessActionContext.class}));
                    DefaultResourceManager.get().registerResource((Resource)tccResource);
                }
            }
            catch (Throwable t) {
                throw new FrameworkException(t, "parser remting service error");
            }
        }
        if (this.isReference(bean, beanName)) {
            remotingBeanDesc.setReference(true);
        }
        return remotingBeanDesc;
    }

    public RemotingDesc getRemotingBeanDesc(String beanName) {
        return remotingServiceMap.get(beanName);
    }

    private static class SingletonHolder {
        private static DefaultRemotingParser INSTANCE = new DefaultRemotingParser();

        private SingletonHolder() {
        }
    }
}

