/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fescar.rm.datasource.sql.struct;

import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fescar.common.exception.ShouldNeverHappenException;
import com.alibaba.fescar.rm.datasource.sql.struct.ColumnMeta;
import com.alibaba.fescar.rm.datasource.sql.struct.Field;
import com.alibaba.fescar.rm.datasource.sql.struct.KeyType;
import com.alibaba.fescar.rm.datasource.sql.struct.Row;
import com.alibaba.fescar.rm.datasource.sql.struct.TableMeta;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class TableRecords {
    @JSONField(serialize=false)
    private TableMeta tableMeta;
    private String tableName;
    private List<Row> rows = new ArrayList<Row>();

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public List<Row> getRows() {
        return this.rows;
    }

    public void setRows(List<Row> rows) {
        this.rows = rows;
    }

    public TableRecords() {
    }

    public TableRecords(TableMeta tableMeta) {
        this.setTableMeta(tableMeta);
    }

    public void setTableMeta(TableMeta tableMeta) {
        if (this.tableMeta != null) {
            throw new ShouldNeverHappenException();
        }
        this.tableMeta = tableMeta;
        this.tableName = tableMeta.getTableName();
    }

    public int size() {
        return this.rows.size();
    }

    public void add(Row row) {
        this.rows.add(row);
    }

    public List<Field> pkRows() {
        final String pkName = this.getTableMeta().getPkName();
        return new ArrayList<Field>(){
            {
                block0: for (Row row : TableRecords.this.rows) {
                    List<Field> fields = row.getFields();
                    for (Field field : fields) {
                        if (!field.getName().equalsIgnoreCase(pkName)) continue;
                        this.add(field);
                        continue block0;
                    }
                }
            }
        };
    }

    public TableMeta getTableMeta() {
        return this.tableMeta;
    }

    public static TableRecords empty(TableMeta tableMeta) {
        return new TableRecords(tableMeta){

            @Override
            public int size() {
                return 0;
            }

            @Override
            public List<Field> pkRows() {
                return new ArrayList<Field>();
            }

            @Override
            public void add(Row row) {
                throw new UnsupportedOperationException("xxx");
            }

            @Override
            public TableMeta getTableMeta() {
                throw new UnsupportedOperationException("xxx");
            }
        };
    }

    public static TableRecords buildRecords(TableMeta tmeta, ResultSet resultSet) throws SQLException {
        TableRecords records = new TableRecords(tmeta);
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int columnCount = resultSetMetaData.getColumnCount();
        while (resultSet.next()) {
            ArrayList<Field> fields = new ArrayList<Field>(columnCount);
            for (int i = 1; i <= columnCount; ++i) {
                String colName = resultSetMetaData.getColumnName(i);
                ColumnMeta col = tmeta.getColumnMeta(colName);
                Field field = new Field();
                field.setName(col.getColumnName());
                if (tmeta.getPkName().equals(field.getName())) {
                    field.setKeyType(KeyType.PrimaryKey);
                }
                field.setType(col.getDataType());
                field.setValue(resultSet.getObject(i));
                fields.add(field);
            }
            Row row = new Row();
            row.setFields(fields);
            records.add(row);
        }
        return records;
    }
}

