/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fescar.rm.datasource.exec;

import com.alibaba.fescar.rm.datasource.ParametersHolder;
import com.alibaba.fescar.rm.datasource.StatementProxy;
import com.alibaba.fescar.rm.datasource.exec.AbstractDMLBaseExecutor;
import com.alibaba.fescar.rm.datasource.exec.StatementCallback;
import com.alibaba.fescar.rm.datasource.sql.SQLDeleteRecognizer;
import com.alibaba.fescar.rm.datasource.sql.SQLRecognizer;
import com.alibaba.fescar.rm.datasource.sql.struct.TableMeta;
import com.alibaba.fescar.rm.datasource.sql.struct.TableRecords;
import com.alibaba.fescar.rm.datasource.undo.KeywordChecker;
import com.alibaba.fescar.rm.datasource.undo.KeywordCheckerFactory;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;

public class DeleteExecutor<T, S extends Statement>
extends AbstractDMLBaseExecutor<T, S> {
    public DeleteExecutor(StatementProxy statementProxy, StatementCallback statementCallback, SQLRecognizer sqlRecognizer) {
        super(statementProxy, statementCallback, sqlRecognizer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected TableRecords beforeImage() throws SQLException {
        SQLDeleteRecognizer visitor = (SQLDeleteRecognizer)this.sqlRecognizer;
        KeywordChecker keywordChecker = KeywordCheckerFactory.getKeywordChecker("mysql");
        TableMeta tmeta = this.getTableMeta(visitor.getTableName());
        ArrayList<String> columns = new ArrayList<String>();
        for (String column : tmeta.getAllColumns().keySet()) {
            columns.add(keywordChecker.checkAndReplace(column));
        }
        StringBuffer selectSQLAppender = new StringBuffer("SELECT ");
        for (int i = 0; i < columns.size(); ++i) {
            selectSQLAppender.append(this.getColumnNameInSQL((String)columns.get(i)));
            if (i >= columns.size() - 1) continue;
            selectSQLAppender.append(", ");
        }
        String whereCondition = null;
        ArrayList<Object> paramAppender = new ArrayList<Object>();
        whereCondition = this.statementProxy instanceof ParametersHolder ? visitor.getWhereCondition((ParametersHolder)((Object)this.statementProxy), paramAppender) : visitor.getWhereCondition();
        selectSQLAppender.append(" FROM " + keywordChecker.checkAndReplace(this.getFromTableInSQL()));
        if (StringUtils.isNotBlank((String)whereCondition)) {
            selectSQLAppender.append(" WHERE " + whereCondition);
        }
        selectSQLAppender.append(" FOR UPDATE");
        String selectSQL = selectSQLAppender.toString();
        TableRecords beforeImage = null;
        PreparedStatement ps = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            if (paramAppender.isEmpty()) {
                st = this.statementProxy.getConnection().createStatement();
                rs = st.executeQuery(selectSQL);
            } else {
                ps = this.statementProxy.getConnection().prepareStatement(selectSQL);
                for (int i = 0; i < paramAppender.size(); ++i) {
                    ps.setObject(i + 1, paramAppender.get(i));
                }
                rs = ps.executeQuery();
            }
            beforeImage = TableRecords.buildRecords(tmeta, rs);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (st != null) {
                st.close();
            }
            if (ps != null) {
                ps.close();
            }
        }
        return beforeImage;
    }

    @Override
    protected TableRecords afterImage(TableRecords beforeImage) throws SQLException {
        return TableRecords.empty(this.getTableMeta());
    }
}

