/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fescar.rm.datasource.exec;

import com.alibaba.fescar.core.context.RootContext;
import com.alibaba.fescar.rm.datasource.ConnectionProxy;
import com.alibaba.fescar.rm.datasource.StatementProxy;
import com.alibaba.fescar.rm.datasource.exec.Executor;
import com.alibaba.fescar.rm.datasource.exec.StatementCallback;
import com.alibaba.fescar.rm.datasource.sql.SQLRecognizer;
import com.alibaba.fescar.rm.datasource.sql.SQLType;
import com.alibaba.fescar.rm.datasource.sql.struct.Field;
import com.alibaba.fescar.rm.datasource.sql.struct.TableMeta;
import com.alibaba.fescar.rm.datasource.sql.struct.TableMetaCache;
import com.alibaba.fescar.rm.datasource.sql.struct.TableRecords;
import com.alibaba.fescar.rm.datasource.undo.SQLUndoLog;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

public abstract class BaseTransactionalExecutor<T, S extends Statement>
implements Executor {
    protected StatementProxy<S> statementProxy;
    protected StatementCallback<T, S> statementCallback;
    protected SQLRecognizer sqlRecognizer;
    private TableMeta tableMeta;

    public BaseTransactionalExecutor(StatementProxy<S> statementProxy, StatementCallback<T, S> statementCallback, SQLRecognizer sqlRecognizer) {
        this.statementProxy = statementProxy;
        this.statementCallback = statementCallback;
        this.sqlRecognizer = sqlRecognizer;
    }

    public Object execute(Object ... args) throws Throwable {
        if (RootContext.inGlobalTransaction()) {
            String xid = RootContext.getXID();
            this.statementProxy.getConnectionProxy().bind(xid);
        }
        if (RootContext.requireGlobalLock()) {
            this.statementProxy.getConnectionProxy().setGlobalLockRequire(true);
        } else {
            this.statementProxy.getConnectionProxy().setGlobalLockRequire(false);
        }
        return this.doExecute(args);
    }

    protected abstract Object doExecute(Object ... var1) throws Throwable;

    protected String buildWhereConditionByPKs(List<Field> pkRows) throws SQLException {
        StringBuffer whereConditionAppender = new StringBuffer();
        for (int i = 0; i < pkRows.size(); ++i) {
            Field field = pkRows.get(i);
            whereConditionAppender.append(this.getColumnNameInSQL(field.getName()) + " = ?");
            if (i >= pkRows.size() - 1) continue;
            whereConditionAppender.append(" OR ");
        }
        return whereConditionAppender.toString();
    }

    protected String getColumnNameInSQL(String columnName) {
        String tableAlias = this.sqlRecognizer.getTableAlias();
        if (tableAlias == null) {
            return columnName;
        }
        return tableAlias + "." + columnName;
    }

    protected String getFromTableInSQL() {
        String tableName = this.sqlRecognizer.getTableName();
        String tableAlias = this.sqlRecognizer.getTableAlias();
        if (tableAlias == null) {
            return tableName;
        }
        return tableName + " " + tableAlias;
    }

    protected TableMeta getTableMeta() {
        return this.getTableMeta(this.sqlRecognizer.getTableName());
    }

    protected TableMeta getTableMeta(String tableName) {
        if (this.tableMeta != null) {
            return this.tableMeta;
        }
        this.tableMeta = TableMetaCache.getTableMeta(this.statementProxy.getConnectionProxy().getDataSourceProxy(), tableName);
        return this.tableMeta;
    }

    protected void prepareUndoLog(TableRecords beforeImage, TableRecords afterImage) throws SQLException {
        if (beforeImage.getRows().size() == 0 && afterImage.getRows().size() == 0) {
            return;
        }
        ConnectionProxy connectionProxy = this.statementProxy.getConnectionProxy();
        TableRecords lockKeyRecords = this.sqlRecognizer.getSQLType() == SQLType.DELETE ? beforeImage : afterImage;
        String lockKeys = this.buildLockKey(lockKeyRecords);
        connectionProxy.appendLockKey(lockKeys);
        SQLUndoLog sqlUndoLog = this.buildUndoItem(beforeImage, afterImage);
        connectionProxy.appendUndoLog(sqlUndoLog);
    }

    protected String buildLockKey(TableRecords rowsIncludingPK) {
        if (rowsIncludingPK.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(rowsIncludingPK.getTableMeta().getTableName());
        sb.append(":");
        int filedSequence = 0;
        for (Field field : rowsIncludingPK.pkRows()) {
            sb.append(field.getValue());
            if (++filedSequence >= rowsIncludingPK.pkRows().size()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    protected SQLUndoLog buildUndoItem(TableRecords beforeImage, TableRecords afterImage) {
        SQLType sqlType = this.sqlRecognizer.getSQLType();
        String tableName = this.sqlRecognizer.getTableName();
        SQLUndoLog sqlUndoLog = new SQLUndoLog();
        sqlUndoLog.setSqlType(sqlType);
        sqlUndoLog.setTableName(tableName);
        sqlUndoLog.setBeforeImage(beforeImage);
        sqlUndoLog.setAfterImage(afterImage);
        return sqlUndoLog;
    }
}

