/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fescar.rm.datasource;

import com.alibaba.fescar.rm.datasource.AbstractConnectionProxy;
import com.alibaba.fescar.rm.datasource.StatementProxy;
import com.alibaba.fescar.rm.datasource.sql.struct.Null;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public abstract class AbstractPreparedStatementProxy
extends StatementProxy<PreparedStatement>
implements PreparedStatement {
    protected ArrayList<Object>[] parameters;

    private void initParameterHolder() throws SQLException {
        int paramCount = ((PreparedStatement)this.targetStatement).getParameterMetaData().getParameterCount();
        this.parameters = new ArrayList[paramCount];
        for (int i = 0; i < paramCount; ++i) {
            this.parameters[i] = new ArrayList();
        }
    }

    public AbstractPreparedStatementProxy(AbstractConnectionProxy connectionProxy, PreparedStatement targetStatement, String targetSQL) throws SQLException {
        super(connectionProxy, targetStatement, targetSQL);
        this.initParameterHolder();
    }

    public AbstractPreparedStatementProxy(AbstractConnectionProxy connectionProxy, PreparedStatement targetStatement) throws SQLException {
        super(connectionProxy, targetStatement);
        this.initParameterHolder();
    }

    public List<Object> getParamsByIndex(int index) {
        return this.parameters[index];
    }

    protected void setParamByIndex(int index, Object x) {
        this.parameters[--index].add(x);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.setParamByIndex(parameterIndex, Null.get());
        ((PreparedStatement)this.targetStatement).setNull(parameterIndex, sqlType);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.setParamByIndex(parameterIndex, x);
        ((PreparedStatement)this.targetStatement).setBoolean(parameterIndex, x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.setParamByIndex(parameterIndex, x);
        ((PreparedStatement)this.targetStatement).setByte(parameterIndex, x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.setParamByIndex(parameterIndex, x);
        ((PreparedStatement)this.targetStatement).setShort(parameterIndex, x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.setParamByIndex(parameterIndex, x);
        ((PreparedStatement)this.targetStatement).setInt(parameterIndex, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.setParamByIndex(parameterIndex, x);
        ((PreparedStatement)this.targetStatement).setLong(parameterIndex, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.setParamByIndex(parameterIndex, Float.valueOf(x));
        ((PreparedStatement)this.targetStatement).setFloat(parameterIndex, x);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.setParamByIndex(parameterIndex, x);
        ((PreparedStatement)this.targetStatement).setDouble(parameterIndex, x);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.setParamByIndex(parameterIndex, x);
        ((PreparedStatement)this.targetStatement).setBigDecimal(parameterIndex, x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.setParamByIndex(parameterIndex, x);
        ((PreparedStatement)this.targetStatement).setString(parameterIndex, x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.setParamByIndex(parameterIndex, x);
        ((PreparedStatement)this.targetStatement).setBytes(parameterIndex, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setParamByIndex(parameterIndex, x);
        ((PreparedStatement)this.targetStatement).setDate(parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setParamByIndex(parameterIndex, x);
        ((PreparedStatement)this.targetStatement).setTime(parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setParamByIndex(parameterIndex, x);
        ((PreparedStatement)this.targetStatement).setTimestamp(parameterIndex, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setParamByIndex(parameterIndex, x);
        ((PreparedStatement)this.targetStatement).setAsciiStream(parameterIndex, x, length);
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setParamByIndex(parameterIndex, x);
        ((PreparedStatement)this.targetStatement).setUnicodeStream(parameterIndex, x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setParamByIndex(parameterIndex, x);
        ((PreparedStatement)this.targetStatement).setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.initParameterHolder();
        ((PreparedStatement)this.targetStatement).clearParameters();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setParamByIndex(parameterIndex, x);
        ((PreparedStatement)this.targetStatement).setObject(parameterIndex, x, targetSqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.setParamByIndex(parameterIndex, x);
        ((PreparedStatement)this.targetStatement).setObject(parameterIndex, x);
    }

    @Override
    public void addBatch() throws SQLException {
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.setParamByIndex(parameterIndex, reader);
        ((PreparedStatement)this.targetStatement).setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        this.setParamByIndex(parameterIndex, x);
        ((PreparedStatement)this.targetStatement).setRef(parameterIndex, x);
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.setParamByIndex(parameterIndex, x);
        ((PreparedStatement)this.targetStatement).setBlob(parameterIndex, x);
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.setParamByIndex(parameterIndex, x);
        ((PreparedStatement)this.targetStatement).setClob(parameterIndex, x);
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.setParamByIndex(parameterIndex, x);
        ((PreparedStatement)this.targetStatement).setArray(parameterIndex, x);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return ((PreparedStatement)this.targetStatement).getMetaData();
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.setParamByIndex(parameterIndex, x);
        ((PreparedStatement)this.targetStatement).setDate(parameterIndex, x, cal);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.setParamByIndex(parameterIndex, x);
        ((PreparedStatement)this.targetStatement).setTime(parameterIndex, x, cal);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.setParamByIndex(parameterIndex, x);
        ((PreparedStatement)this.targetStatement).setTimestamp(parameterIndex, x, cal);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.setParamByIndex(parameterIndex, Null.get());
        ((PreparedStatement)this.targetStatement).setNull(parameterIndex, sqlType, typeName);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.setParamByIndex(parameterIndex, x);
        ((PreparedStatement)this.targetStatement).setURL(parameterIndex, x);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return ((PreparedStatement)this.targetStatement).getParameterMetaData();
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.setParamByIndex(parameterIndex, x);
        ((PreparedStatement)this.targetStatement).setRowId(parameterIndex, x);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.setParamByIndex(parameterIndex, value);
        ((PreparedStatement)this.targetStatement).setNString(parameterIndex, value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.setParamByIndex(parameterIndex, value);
        ((PreparedStatement)this.targetStatement).setNCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.setParamByIndex(parameterIndex, value);
        ((PreparedStatement)this.targetStatement).setNClob(parameterIndex, value);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setParamByIndex(parameterIndex, reader);
        ((PreparedStatement)this.targetStatement).setClob(parameterIndex, reader, length);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.setParamByIndex(parameterIndex, inputStream);
        ((PreparedStatement)this.targetStatement).setBlob(parameterIndex, inputStream, length);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setParamByIndex(parameterIndex, reader);
        ((PreparedStatement)this.targetStatement).setNClob(parameterIndex, reader, length);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.setParamByIndex(parameterIndex, xmlObject);
        ((PreparedStatement)this.targetStatement).setSQLXML(parameterIndex, xmlObject);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.setParamByIndex(parameterIndex, x);
        ((PreparedStatement)this.targetStatement).setObject(parameterIndex, x, targetSqlType, scaleOrLength);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.setParamByIndex(parameterIndex, x);
        ((PreparedStatement)this.targetStatement).setAsciiStream(parameterIndex, x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.setParamByIndex(parameterIndex, x);
        ((PreparedStatement)this.targetStatement).setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setParamByIndex(parameterIndex, reader);
        ((PreparedStatement)this.targetStatement).setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.setParamByIndex(parameterIndex, x);
        ((PreparedStatement)this.targetStatement).setAsciiStream(parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.setParamByIndex(parameterIndex, x);
        ((PreparedStatement)this.targetStatement).setBinaryStream(parameterIndex, x);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.setParamByIndex(parameterIndex, reader);
        ((PreparedStatement)this.targetStatement).setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.setParamByIndex(parameterIndex, value);
        ((PreparedStatement)this.targetStatement).setNCharacterStream(parameterIndex, value);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.setParamByIndex(parameterIndex, reader);
        ((PreparedStatement)this.targetStatement).setClob(parameterIndex, reader);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.setParamByIndex(parameterIndex, inputStream);
        ((PreparedStatement)this.targetStatement).setBlob(parameterIndex, inputStream);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.setParamByIndex(parameterIndex, reader);
        ((PreparedStatement)this.targetStatement).setNClob(parameterIndex, reader);
    }
}

