/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fescar.discovery.registry;

import com.alibaba.fescar.common.exception.NotSupportYetException;
import com.alibaba.fescar.config.ConfigurationFactory;
import com.alibaba.fescar.discovery.registry.EurekaRegistryServiceImpl;
import com.alibaba.fescar.discovery.registry.FileRegistryServiceImpl;
import com.alibaba.fescar.discovery.registry.NacosRegistryServiceImpl;
import com.alibaba.fescar.discovery.registry.RedisRegistryServiceImpl;
import com.alibaba.fescar.discovery.registry.RegistryService;
import com.alibaba.fescar.discovery.registry.RegistryType;
import com.alibaba.fescar.discovery.registry.ZookeeperRegisterServiceImpl;
import com.alibaba.fescar.discovery.registry.consul.ConsulRegistryServiceImpl;
import com.alibaba.nacos.api.naming.listener.EventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegistryFactory.class);

    public static RegistryService getInstance() {
        RegistryService<EventListener> registryService;
        RegistryType registryType = null;
        try {
            registryType = RegistryType.getType(ConfigurationFactory.FILE_INSTANCE.getConfig("registry.type"));
        }
        catch (Exception exx) {
            LOGGER.error(exx.getMessage());
        }
        switch (registryType) {
            case Nacos: {
                registryService = NacosRegistryServiceImpl.getInstance();
                break;
            }
            case Redis: {
                registryService = RedisRegistryServiceImpl.getInstance();
                break;
            }
            case Eureka: {
                registryService = EurekaRegistryServiceImpl.getInstance();
                break;
            }
            case File: {
                registryService = FileRegistryServiceImpl.getInstance();
                break;
            }
            case ZK: {
                registryService = ZookeeperRegisterServiceImpl.getInstance();
                break;
            }
            case Consul: {
                registryService = ConsulRegistryServiceImpl.getInstance();
                break;
            }
            default: {
                throw new NotSupportYetException("not support register type:" + (Object)((Object)registryType));
            }
        }
        return registryService;
    }
}

