/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fescar.discovery.loadbalance;

import com.alibaba.fescar.common.loader.LoadLevel;
import com.alibaba.fescar.discovery.loadbalance.AbstractLoadBalance;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

@LoadLevel(name="RoundRobinLoadBalance", order=1)
public class RoundRobinLoadBalance
extends AbstractLoadBalance {
    private final AtomicInteger sequence = new AtomicInteger();

    @Override
    protected <T> T doSelect(List<T> invokers) {
        int length = invokers.size();
        return invokers.get(this.getPositiveSequence() % length);
    }

    private int getPositiveSequence() {
        int next;
        int current;
        while (!this.sequence.compareAndSet(current, next = (current = this.sequence.get()) >= Integer.MAX_VALUE ? 0 : current + 1)) {
        }
        return current;
    }
}

