/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fescar.core.protocol.transaction;

import com.alibaba.fescar.core.protocol.MergedMessage;
import com.alibaba.fescar.core.protocol.transaction.AbstractTransactionRequestToTC;
import java.nio.ByteBuffer;

public abstract class AbstractGlobalEndRequest
extends AbstractTransactionRequestToTC
implements MergedMessage {
    protected long transactionId;
    protected String extraData;

    public long getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(long transactionId) {
        this.transactionId = transactionId;
    }

    public String getExtraData() {
        return this.extraData;
    }

    public void setExtraData(String extraData) {
        this.extraData = extraData;
    }

    @Override
    public byte[] encode() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(256);
        byteBuffer.putLong(this.transactionId);
        if (this.extraData != null) {
            byte[] bs = this.extraData.getBytes(UTF8);
            byteBuffer.putShort((short)bs.length);
            if (bs.length > 0) {
                byteBuffer.put(bs);
            }
        } else {
            byteBuffer.putShort((short)0);
        }
        byteBuffer.flip();
        byte[] content = new byte[byteBuffer.limit()];
        byteBuffer.get(content);
        return content;
    }

    @Override
    public void decode(ByteBuffer byteBuffer) {
        this.transactionId = byteBuffer.getLong();
        short len = byteBuffer.getShort();
        if (len > 0) {
            byte[] bs = new byte[len];
            byteBuffer.get(bs);
            this.setExtraData(new String(bs, UTF8));
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("transactionId=");
        result.append(this.transactionId);
        result.append(",");
        result.append("extraData=");
        result.append(this.extraData);
        return result.toString();
    }
}

