/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.support.config;

import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.SymbolTable;
import com.alibaba.fastjson2.filter.Filter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class FastJsonConfig {
    private Charset charset = StandardCharsets.UTF_8;
    private String dateFormat = "yyyy-MM-dd HH:mm:ss";
    private JSONReader.Feature[] readerFeatures = new JSONReader.Feature[0];
    private JSONWriter.Feature[] writerFeatures = new JSONWriter.Feature[]{JSONWriter.Feature.WriteByteArrayAsBase64, JSONWriter.Feature.BrowserSecure};
    private Filter[] readerFilters = new Filter[0];
    private Filter[] writerFilters = new Filter[0];
    private boolean writeContentLength = true;
    private boolean jsonb;
    private SymbolTable symbolTable;
    private transient JSONReader.Context readerContext;
    private transient JSONWriter.Context writerContext;

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
        this.clearContext();
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
        this.clearContext();
    }

    public JSONReader.Feature[] getReaderFeatures() {
        return this.readerFeatures;
    }

    public void setReaderFeatures(JSONReader.Feature ... readerFeatures) {
        this.readerFeatures = readerFeatures;
        this.readerContext = null;
    }

    public JSONWriter.Feature[] getWriterFeatures() {
        return this.writerFeatures;
    }

    public void setWriterFeatures(JSONWriter.Feature ... writerFeatures) {
        this.writerFeatures = writerFeatures;
        this.writerContext = null;
    }

    public Filter[] getReaderFilters() {
        return this.readerFilters;
    }

    public void setReaderFilters(Filter ... readerFilters) {
        this.readerFilters = readerFilters;
        this.readerContext = null;
    }

    public Filter[] getWriterFilters() {
        return this.writerFilters;
    }

    public void setWriterFilters(Filter ... writerFilters) {
        this.writerFilters = writerFilters;
        this.writerContext = null;
    }

    public boolean isWriteContentLength() {
        return this.writeContentLength;
    }

    public void setWriteContentLength(boolean writeContentLength) {
        this.writeContentLength = writeContentLength;
    }

    public boolean isJSONB() {
        return this.jsonb;
    }

    public void setJSONB(boolean jsonb) {
        this.jsonb = jsonb;
        this.clearContext();
    }

    public SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public void setSymbolTable(String ... names) {
        this.symbolTable = JSONB.symbolTable((String[])names);
        this.clearContext();
    }

    public void clearContext() {
        this.readerContext = null;
        this.writerContext = null;
    }

    public JSONReader.Context readerContext() {
        JSONReader.Context context = this.readerContext;
        if (context == null) {
            context = new JSONReader.Context(JSONFactory.getDefaultObjectReaderProvider(), this.jsonb ? this.symbolTable : null, this.readerFilters, this.readerFeatures);
            context.setDateFormat(this.dateFormat);
            this.readerContext = context;
        }
        return context;
    }

    public JSONWriter.Context writerContext() {
        JSONWriter.Context context = this.writerContext;
        if (context == null) {
            context = new JSONWriter.Context(this.dateFormat, this.writerFeatures);
            if (this.dateFormat != null && !this.dateFormat.isEmpty()) {
                context.setDateFormat(this.dateFormat);
            }
            if (this.writerFilters != null && this.writerFilters.length > 0) {
                context.configFilter(this.writerFilters);
            }
            this.writerContext = context;
        }
        return context;
    }
}

