/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.support.spring.codec;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.filter.Filter;
import com.alibaba.fastjson2.support.config.FastJsonConfig;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.AbstractEncoder;
import org.springframework.core.codec.EncodingException;
import org.springframework.core.codec.Hints;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.MediaType;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.MimeType;
import reactor.core.publisher.Flux;

public final class Fastjson2Encoder
extends AbstractEncoder<Object> {
    private final FastJsonConfig config;

    public Fastjson2Encoder() {
        this(new FastJsonConfig(), new MimeType[]{MediaType.APPLICATION_JSON, new MediaType("application", "*+json")});
    }

    public Fastjson2Encoder(FastJsonConfig config, MimeType ... mimeTypes) {
        MimeType[] mimeTypeArray;
        if (mimeTypes == null || mimeTypes.length == 0) {
            MimeType[] mimeTypeArray2 = new MimeType[2];
            mimeTypeArray2[0] = MediaType.APPLICATION_JSON;
            mimeTypeArray = mimeTypeArray2;
            mimeTypeArray2[1] = new MediaType("application", "*+json");
        } else {
            mimeTypeArray = mimeTypes;
        }
        super(mimeTypeArray);
        this.config = config;
    }

    @NonNull
    public Flux<DataBuffer> encode(@NonNull Publisher<?> inputStream, @NonNull DataBufferFactory bufferFactory, @NonNull ResolvableType elementType, MimeType mimeType, Map<String, Object> hints) {
        return Flux.from(inputStream).map(val -> this.encodeValue(val, bufferFactory, elementType, mimeType, hints));
    }

    @NonNull
    public DataBuffer encodeValue(@Nullable Object value, @NonNull DataBufferFactory bufferFactory, @NonNull ResolvableType valueType, MimeType mimeType, Map<String, Object> hints) {
        DataBuffer dataBuffer;
        byte[] curBytes;
        byte[] bytes = null;
        if (value instanceof String) {
            String str = (String)value;
            if (JSON.isValidObject((String)str)) {
                bytes = str.getBytes(this.config.getCharset());
            }
        } else if (value instanceof byte[] && JSON.isValid((byte[])(curBytes = (byte[])value))) {
            bytes = (byte[])value;
        }
        if (bytes != null) {
            int length = bytes.length;
            DataBuffer buffer = bufferFactory.allocateBuffer(length).write(bytes, 0, length);
            Hints.touchDataBuffer((DataBuffer)buffer, hints, (Log)this.logger);
            return buffer;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            JSON.writeTo((OutputStream)baos, (Object)value, (String)this.config.getDateFormat(), (Filter[])this.config.getWriterFilters(), (JSONWriter.Feature[])this.config.getWriterFeatures());
            DataBuffer buffer = bufferFactory.allocateBuffer(baos.size());
            baos.writeTo(buffer.asOutputStream());
            Hints.touchDataBuffer((DataBuffer)buffer, hints, (Log)this.logger);
            dataBuffer = buffer;
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new EncodingException("JSON#writeTo cannot serialize '" + value + "' to 'OutputStream'", (Throwable)e);
            }
        }
        baos.close();
        return dataBuffer;
    }
}

