/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.support.solon;

import com.alibaba.fastjson2.support.solon.Fastjson2StringSerializer;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterProvider;
import org.noear.solon.core.convert.Converter;
import org.noear.solon.serialization.JsonRenderFactory;

public abstract class Fastjson2RenderFactoryBase
implements JsonRenderFactory {
    protected Fastjson2StringSerializer serializer = new Fastjson2StringSerializer();

    public Fastjson2RenderFactoryBase() {
        this.serializer.getSerializeConfig().setDateFormat("millis");
    }

    public Fastjson2StringSerializer getSerializer() {
        return this.serializer;
    }

    public ObjectWriterProvider config() {
        return this.serializer.getSerializeConfig().getProvider();
    }

    public <T> void addEncoder(Class<T> clz, ObjectWriter encoder) {
        this.config().register(clz, encoder);
    }

    public <T> void addConvertor(Class<T> clz, Converter<T, Object> converter) {
        this.addEncoder(clz, (out, obj, fieldName, fieldType, features) -> {
            Object val = converter.convert(obj);
            if (val == null) {
                out.writeNull();
            } else if (val instanceof String) {
                out.writeString((String)val);
            } else if (val instanceof Number) {
                if (val instanceof Long) {
                    out.writeInt64(((Number)val).longValue());
                } else if (val instanceof Integer) {
                    out.writeInt32(((Number)val).intValue());
                } else if (val instanceof Float) {
                    out.writeDouble((double)((Number)val).floatValue());
                } else {
                    out.writeDouble(((Number)val).doubleValue());
                }
            } else {
                throw new IllegalArgumentException("The result type of the converter is not supported: " + val.getClass().getName());
            }
        });
    }
}

