/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.internal.processor;

import com.alibaba.fastjson2.internal.processor.CodeGenUtils;
import com.alibaba.fastjson2.internal.processor.JavacTreeUtils;
import com.alibaba.fastjson2.util.JDKUtils;
import java.lang.reflect.Method;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;

@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@SupportedAnnotationTypes(value={"com.alibaba.fastjson2.annotation.JSONCompiled", "com.alibaba.fastjson2.annotation.JSONBuilder", "com.alibaba.fastjson2.annotation.JSONCreator", "com.alibaba.fastjson2.annotation.JSONField", "com.alibaba.fastjson2.annotation.JSONType"})
public class JSONBaseAnnotationProcessor
extends AbstractProcessor {
    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        JSONBaseAnnotationProcessor.addOpensSinceJava9();
        super.init(JavacTreeUtils.unwrapProcessingEnv(processingEnv));
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        return false;
    }

    private static void addOpensSinceJava9() {
        if (CodeGenUtils.JVM_VERSION >= 9) {
            Class<?> cModule = null;
            try {
                cModule = Class.forName("java.lang.Module");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            Object jdkCompilerModule = JSONBaseAnnotationProcessor.getJdkCompilerModule();
            Object ownModule = JSONBaseAnnotationProcessor.getOwnModule();
            String[] allPkgs = new String[]{"com.sun.tools.javac.api", "com.sun.tools.javac.code", "com.sun.tools.javac.comp", "com.sun.tools.javac.file", "com.sun.tools.javac.main", "com.sun.tools.javac.model", "com.sun.tools.javac.parser", "com.sun.tools.javac.processing", "com.sun.tools.javac.tree", "com.sun.tools.javac.util"};
            try {
                Method m = cModule.getDeclaredMethod("implAddOpens", String.class, cModule);
                long firstFieldOffset = JDKUtils.UNSAFE.objectFieldOffset(Parent.class.getDeclaredField("first"));
                JDKUtils.UNSAFE.putBooleanVolatile(m, firstFieldOffset, true);
                for (String p : allPkgs) {
                    m.invoke(jdkCompilerModule, p, ownModule);
                }
            }
            catch (Exception e) {
                return;
            }
        }
    }

    private static Object getJdkCompilerModule() {
        try {
            Class<?> moduleLayer = Class.forName("java.lang.ModuleLayer");
            Method boot = moduleLayer.getDeclaredMethod("boot", new Class[0]);
            Object bootLayer = boot.invoke(null, new Object[0]);
            Class<?> clazz = Class.forName("java.util.Optional");
            Method findModule = moduleLayer.getDeclaredMethod("findModule", String.class);
            Object compiler = findModule.invoke(bootLayer, "jdk.compiler");
            return clazz.getDeclaredMethod("get", new Class[0]).invoke(compiler, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Object getOwnModule() {
        try {
            Class<Class> clazz = Class.class;
            Method getModule = clazz.getDeclaredMethod("getModule", new Class[0]);
            return getModule.invoke(JSONBaseAnnotationProcessor.class, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static class Parent {
        boolean first;

        private Parent() {
        }
    }
}

