/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark.simdjson;

import com.alibaba.fastjson2.JSON;
import io.github.wycst.wast.json.options.ReadOption;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class Twitter {
    static final String file = "data/simd-json/twitter.json";
    static byte[] bytes;

    @Benchmark
    public void fastjson2_parse(Blackhole bh) {
        bh.consume(JSON.parseObject((byte[])bytes, SimdJsonTwitter.class));
    }

    public void wast_parse(Blackhole bh) {
        bh.consume(io.github.wycst.wast.json.JSON.parseObject((byte[])bytes, SimdJsonTwitter.class, (ReadOption[])new ReadOption[0]));
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().include(Twitter.class.getName()).mode(Mode.Throughput).warmupIterations(3).timeUnit(TimeUnit.MILLISECONDS).forks(1).build();
        new Runner(options).run();
    }

    static {
        try (InputStream is = Twitter.class.getClassLoader().getResourceAsStream(file);){
            String str = IOUtils.toString((InputStream)is, (String)"UTF-8");
            bytes = str.getBytes();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public record SimdJsonTwitter(List<SimdJsonStatus> statuses) {
    }

    public record SimdJsonStatus(SimdJsonUser user) {
    }

    public record SimdJsonUser(boolean default_profile, String screen_name) {
    }
}

