/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark.simdjson;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.benchmark.simdjson.SimdJsonPaddingUtil;
import io.github.wycst.wast.json.options.ReadOption;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.simdjson.JsonValue;
import org.simdjson.SimdJsonParser;

@State(value=Scope.Benchmark)
@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.SECONDS)
public class ParseBenchmark {
    @Param(value={"/data/simd-json/twitter.json", "/data/simd-json/gsoc-2018.json", "/data/simd-json/github_events.json"})
    String fileName;
    private final SimdJsonParser simdJsonParser = new SimdJsonParser();
    private byte[] buffer;
    private byte[] bufferPadded;

    @Setup(value=Level.Trial)
    public void setup() throws IOException {
        try (InputStream is = ParseBenchmark.class.getResourceAsStream(this.fileName);){
            byte[] buf = new byte[0x4000000];
            int count = is.read(buf);
            this.buffer = Arrays.copyOf(buf, count);
            this.bufferPadded = SimdJsonPaddingUtil.padded(this.buffer);
        }
    }

    @Benchmark
    public JsonValue simdjson() {
        return this.simdJsonParser.parse(this.buffer, this.buffer.length);
    }

    @Benchmark
    public Object fastjson() {
        return JSON.parse((byte[])this.buffer, (JSONReader.Feature[])new JSONReader.Feature[0]);
    }

    @Benchmark
    public Object wast() {
        return io.github.wycst.wast.json.JSON.parse((byte[])this.buffer, (ReadOption[])new ReadOption[0]);
    }

    @Benchmark
    public JsonValue simdjsonPadded() {
        return this.simdJsonParser.parse(this.bufferPadded, this.buffer.length);
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().include(ParseBenchmark.class.getName()).jvmArgsAppend(new String[]{"--add-opens=java.base/java.time=ALL-UNNAMED", "--add-modules=jdk.incubator.vector"}).mode(Mode.Throughput).timeUnit(TimeUnit.MILLISECONDS).forks(1).build();
        new Runner(options).run();
    }
}

