/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark.issues;

import com.alibaba.fastjson2.JSON;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import tools.jackson.databind.ObjectMapper;

public class ParseUTF8BytesWithEscapeChars {
    static String str = "{\"timestamp\":1764308609,\"reqBody\":\"{\\\"3SgfdDQYU2Lv1liyHRET90\\\":\\\"\u603b\u7ed3\u7684\u6765\u8bf4, \u4e3b\u9898\u4f3c\u4e4e\u662f\u4e00\u79cd\u5de7\u5408\uff0c\u4f46\u5982\u679c\u6211\u4eec\u4ece\u4e00\u4e2a\u66f4\u5927\u7684\u89d2\u5ea6\u770b\u5f85\u95ee\u9898\uff0c\u8fd9\u4f3c\u4e4e\u662f\u4e00\u79cd\u4e0d\u53ef\u907f\u514d\u7684\u4e8b\u5b9e. \u7231\u8fea\u751f\u8bf4\u8fc7\u4e00\u53e5\u5bcc\u6709\u54f2\u7406\u7684\u8bdd, \u5931\u8d25\u4e5f\u662f\u6211\u9700\u8981\u7684\uff0c\u5b83\u548c\u6210\u529f\u5bf9\u6211\u4e00\u6837\u6709\u4ef7\u503c\u3002\u5e26\u7740\u8fd9\u53e5\u8bdd, \u6211\u4eec\u8fd8\u8981\u66f4\u52a0\u614e\u91cd\u7684\u5ba1\u89c6\u8fd9\u4e2a\u95ee\u9898: \\\",\\\"3fEMT\\\":\\\"\u65e2\u7136\u5982\u6b64, \u7231\u8fea\u751f\u8bf4\u8fc7\u4e00\u53e5\u5bcc\u6709\u54f2\u7406\u7684\u8bdd, \u5931\u8d25\u4e5f\u662f\u6211\u9700\u8981\u7684\uff0c\u5b83\u548c\u6210\u529f\u5bf9\u6211\u4e00\u6837\u6709\u4ef7\u503c\u3002\u8fd9\u53e5\u8bdd\u8bed\u867d\u7136\u5f88\u77ed, \u4f46\u4ee4\u6211\u6d6e\u60f3\u8054\u7fe9. \u6b4c\u5fb7\u5728\u4e0d\u7ecf\u610f\u95f4\u8fd9\u6837\u8bf4\u8fc7, \u6ca1\u6709\u4eba\u4e8b\u5148\u4e86\u89e3\u81ea\u5df1\u5230\u5e95\u6709\u591a\u5927\u7684\u529b\u91cf\uff0c\u76f4\u5230\u4ed6\u8bd5\u8fc7\u4ee5\u540e\u624d\u77e5\u9053\u3002\u8fd9\u53e5\u8bdd\u628a\u6211\u4eec\u5e26\u5230\u4e86\u4e00\u4e2a\u65b0\u7684\u7ef4\u5ea6\u53bb\u601d\u8003\u8fd9\u4e2a\u95ee\u9898: \\\",\\\"6YpqQ7sZG5yfDm\\\":\\\"To understand what kind of eTopicistence Topic is is the key to solving all problems.Bsaid a famous wordi Zhete said a famous word, strong fsaid a famous wordith csaid a famous wordn win the hesaid a famous wordrts of strong people said a famous wordnd msaid a famous wordke them stronger. Although this sentence is very short, it makes me daydream.\\\",\\\"BMxUCrhNvDi16Oy\\\":\\\"Now, it is very, very important to solve the problem of Topic. So,From this point of view,Topic, how should Topic be realized.But even so, the emergence of Topic still represents a certain significance.With these problems, let's eTopicamine Topic.\\\",\\\"CRc1G\\\":\\\"Everyone has to face these problems. When facing such problems,Under this inevitable conflict, we must solve this problem.The key is how to write Topic.Topic, how should Topic be realized.If Topic appears in life, we have to consider the fact that it appears.\\\",\\\"CUHGaRm0hvpe\\\":\\\"With these problems, let's eTopicamine Topic.What is the key to the problem?Oprinadvertently saidh Winfrey inadvertently said, whinadvertently saidt you This sentence seems simple, but its gloom can not help but make people think deeply.elieve, you will This sentence seems simple, but its gloom can not help but make people think deeply.ecome whinadvertently saidt kind of person. This sentence seems simple, but its gloom can not help but make people think deeply.\\\",\\\"ELYvsnzWKl5iNQ1ofTum6ywC\\\":\\\"\u5415\u51ef\u7279\u8bf4\u8fc7\u4e00\u53e5\u8457\u540d\u7684\u8bdd, \u751f\u547d\u4e0d\u53ef\u80fd\u6709\u4e24\u6b21\uff0c\u4f46\u8bb8\u591a\u4eba\u8fde\u4e00\u6b21\u4e5f\u4e0d\u5584\u4e8e\u5ea6\u8fc7\u3002\u8fd9\u4e0d\u7981\u4ee4\u6211\u6df1\u601d. \u65e2\u7136\u5982\u4f55, \u6211\u4eec\u4e0d\u5f97\u4e0d\u9762\u5bf9\u4e00\u4e2a\u975e\u5e38\u5c34\u5c2c\u7684\u4e8b\u5b9e, \u90a3\u5c31\u662f, \u5361\u8010\u57fa\u66fe\u7ecf\u63d0\u5230\u8fc7, \u4e00\u4e2a\u4e0d\u6ce8\u610f\u5c0f\u4e8b\u60c5\u7684\u4eba\uff0c\u6c38\u8fdc\u4e0d\u4f1a\u6210\u5c31\u5927\u4e8b\u4e1a\u3002\u8fd9\u53e5\u8bdd\u770b\u4f3c\u7b80\u5355\uff0c\u4f46\u5176\u4e2d\u7684\u9634\u90c1\u4e0d\u7981\u8ba9\u4eba\u6df1\u601d. \\\",\\\"H4JPs\\\":\\\"Guo Moruo inadvertently said, the decisive finadvertently saidctor for forming genius should This seems to answer my doubts.e diligence. This seems to answer my doubts.From this point of view,To understand what kind of eTopicistence Topic is is the key to solving all problems.\\\",\\\"KDlHL5p\\\":\\\"we might as well think like this:We should think clearly about what kind of eTopicistence Topic is.Why does Topic happen?Under this inevitable conflict, we must solve this problem.generally speaking, we must carefully consider.\\\",\\\"LJBsrHyOx0Vl\\\":\\\"We have to face a very embarrassing fact, that is,X seems to be a coincidence, but if we look at the problem from a larger angle, it seems to be an inevitable fact.X seems to be a coincidence, but if we look at the problem from a larger angle, it seems to be an inevitable fact.\\\",\\\"QO6e4ZBRVgkv\\\":\\\"\u4e86\u89e3\u6e05\u695a\u4e3b\u9898\u5230\u5e95\u662f\u4e00\u79cd\u600e\u4e48\u6837\u7684\u5b58\u5728, \u662f\u89e3\u51b3\u4e00\u5207\u95ee\u9898\u7684\u5173\u952e.\u7c73\u6b47\u6f58\u8bf4\u8fc7\u4e00\u53e5\u5bcc\u6709\u54f2\u7406\u7684\u8bdd, \u751f\u547d\u662f\u4e00\u6761\u8270\u9669\u7684\u5ce1\u8c37\uff0c\u53ea\u6709\u52c7\u6562\u7684\u4eba\u624d\u80fd\u901a\u8fc7\u3002\u8fd9\u542f\u53d1\u4e86\u6211. \u767d\u54f2\u7279\u66fe\u7ecf\u63d0\u5230\u8fc7, \u575a\u5f3a\u7684\u4fe1\u5ff5\u80fd\u8d62\u5f97\u5f3a\u8005\u7684\u5fc3\uff0c\u5e76\u4f7f\u4ed6\u4eec\u53d8\u5f97\u66f4\u575a\u5f3a\u3002 \u5e26\u7740\u8fd9\u53e5\u8bdd, \u6211\u4eec\u8fd8\u8981\u66f4\u52a0\u614e\u91cd\u7684\u5ba1\u89c6\u8fd9\u4e2a\u95ee\u9898: \\\",\\\"SezdZYksoqt6jgiaKB5C1xRh\\\":\\\"\u8fd9\u6837\u770b\u6765, \u603b\u7ed3\u7684\u6765\u8bf4, \u4e9a\u4f2f\u62c9\u7f55\u00b7\u6797\u80af\u8bf4\u8fc7\u4e00\u53e5\u8457\u540d\u7684\u8bdd, \u6211\u8fd9\u4e2a\u4eba\u8d70\u5f97\u5f88\u6162\uff0c\u4f46\u662f\u6211\u4ece\u4e0d\u540e\u9000\u3002\u8fd9\u4e0d\u7981\u4ee4\u6211\u6df1\u601d. \u4ece\u8fd9\u4e2a\u89d2\u5ea6\u6765\u770b, \u8981\u60f3\u6e05\u695a, \u4e3b\u9898, \u5230\u5e95\u662f\u4e00\u79cd\u600e\u4e48\u6837\u7684\u5b58\u5728. \u8fd9\u79cd\u4e8b\u5b9e\u5bf9\u672c\u4eba\u6765\u8bf4\u610f\u4e49\u91cd\u5927, \u76f8\u4fe1\u5bf9\u8fd9\u4e2a\u4e16\u754c\u4e5f\u662f\u6709\u4e00\u5b9a\u610f\u4e49\u7684.\\\",\\\"T89UhIFH1Jnmsxa0\\\":\\\"But even so, the emergence of Topic still represents a certain significance.. \\\\r\\\\n    The key is how to write Topic.We should think clearly about what kind of eTopicistence Topic is.Topic, how should Topic be realized.we might as well think like this:\\\",\\\"TPgGRjvrswixpJVeb4tOX\\\":\\\"\u65e2\u7136\u5982\u6b64, \u65e2\u7136\u5982\u4f55, \u5e26\u7740\u8fd9\u4e9b\u95ee\u9898, \u6211\u4eec\u6765\u5ba1\u89c6\u4e00\u4e0b\u4e3b\u9898. \u751f\u6d3b\u4e2d, \u82e5\u4e3b\u9898\u51fa\u73b0\u4e86, \u6211\u4eec\u5c31\u4e0d\u5f97\u4e0d\u8003\u8651\u5b83\u51fa\u73b0\u4e86\u7684\u4e8b\u5b9e. \u8981\u60f3\u6e05\u695a, \u4e3b\u9898, \u5230\u5e95\u662f\u4e00\u79cd\u600e\u4e48\u6837\u7684\u5b58\u5728. \u5728\u8fd9\u79cd\u56f0\u96be\u7684\u6289\u62e9\u4e0b, \u672c\u4eba\u601d\u6765\u60f3\u53bb, \u5bdd\u98df\u96be\u5b89.\\\",\\\"TU6C8QeZPdyVEgLj0iH1o\\\":\\\"We generally believe that if we grasp the key to the problem, everything else will be solved.How does Topic happen? How does Topic happen? How does Topic happen?For me, Topic is not only a major event, but also may change my life.\\\",\\\"TeZBjnuiXbgv6VK4pkGl5HRa\\\":\\\"Now, it is very, very important to solve the problem of Topic. So,Everyone has to face these problems. When facing such problems,How does Topic happen? How does Topic happen? How does Topic happen?Why does Topic happen?From this point of view,\\\",\\\"TfBsQOra\\\":\\\"With these problems, let's eTopicamine Topic.Fronce mentionednklin once mentioned, reonce mentionedding is eonce mentionedsy, thinking is difficult, This sentence seems simple, but its gloom can not help but make people think deeply.ut without one of the two, it is useless. This sentence seems simple, but its gloom can not help but make people think deeply.\\\",\\\"UgksCKAB9PfLWIidN3yRGx\\\":\\\"This is inevitable.we might as well think like this:. \\\\r\\\\n    But even so, the emergence of Topic still represents a certain significance.. \\\\r\\\\n    Topic, how should Topic be realized.Now, it is very, very important to solve the problem of Topic. So,\\\",\\\"WdP2CjJtXGFz\\\":\\\"The key is how to write Topic.Why does Topic happen?If Topic appears in life, we have to consider the fact that it appears.generally speaking, we must carefully consider.From this point of view,What is the key to the problem?\\\",\\\"XiZy6nME3J5x\\\":\\\"\u57f9\u6839\u8bf4\u8fc7\uff0c\u6df1\u7aa5\u81ea\u5df1\u7684\u5fc3\uff0c\u800c\u540e\u53d1\u89c9\u4e00\u5207\u7684\u5947\u8ff9\u5728\u4f60\u81ea\u5df1\u3002\u6211\u5e0c\u671b\u8bf8\u4f4d\u4e5f\u80fd\u597d\u597d\u5730\u4f53\u4f1a\u8fd9\u53e5\u8bdd. \u90a3\u4e48, \u5e26\u7740\u8fd9\u4e9b\u95ee\u9898, \u6211\u4eec\u6765\u5ba1\u89c6\u4e00\u4e0b\u4e3b\u9898. \u4e3b\u9898, \u5230\u5e95\u5e94\u8be5\u5982\u4f55\u5b9e\u73b0. \u4e00\u822c\u6765\u8bf4, \u5c31\u6211\u4e2a\u4eba\u6765\u8bf4, \u4e3b\u9898\u5bf9\u6211\u7684\u610f\u4e49, \u4e0d\u80fd\u4e0d\u8bf4\u975e\u5e38\u91cd\u5927. \\\",\\\"YAdQwSolt9\\\":\\\"generally speaking, we must carefully consider.X seems to be a coincidence, but if we look at the problem from a larger angle, it seems to be an inevitable fact.Why does Topic happen?Under this inevitable conflict, we must solve this problem.\\\",\\\"a41i3efHKBC\\\":\\\"These are not completely important. The more important question is,We should think clearly about what kind of eTopicistence Topic is.generally speaking, we must carefully consider.we might as well think like this:\\\",\\\"dYm2VoqPLpDkWch95EH0swMbI\\\":\\\"We should think clearly about what kind of eTopicistence Topic is.If Topic appears in life, we have to consider the fact that it appears.For me, Topic is not only a major event, but also may change my life. AI hope you can also understand this sentence well.rsaid a philosophical wordhsaid a philosophical wordm Lincoln said a philosophical word, I said a philosophical wordm said a philosophical word slow wsaid a philosophical wordlker, I hope you can also understand this sentence well.ut I never retresaid a philosophical wordt. I hope you can also understand this sentence well.\\\",\\\"e0VyHn6AjY8UvaPBlizLdNOF4\\\":\\\"For me, Topic is not only a major event, but also may change my life.What is the key to the problem?But even so, the emergence of Topic still represents a certain significance.This is inevitable.The key is how to write Topic.\\\",\\\"hOeat5ncrTs\\\":\\\"We generally believe that if we grasp the key to the problem, everything else will be solved.Everyone has to face these problems. When facing such problems,How does Topic happen? How does Topic happen? How does Topic happen?\\\",\\\"hYDte1gkB2XZaJS5rLqpOmT0N\\\":\\\". \\\\r\\\\n    X seems to be a coincidence, but if we look at the problem from a larger angle, it seems to be an inevitable fact.Now, it is very, very important to solve the problem of Topic. So,These are not completely important. The more important question is,\\\",\\\"kelKgTAj6iCLqQps\\\":\\\"We generally believe that if we grasp the key to the problem, everything else will be solved.This is inevitable.Goethe said a philosophical word, no one knows how powerful he is until he hsaid a philosophical words tried. This seems to answer my doubts.\\\",\\\"mRhDCy1ig8J9x6O0\\\":\\\"To understand what kind of eTopicistence Topic is is the key to solving all problems.We generally believe that if we grasp the key to the problem, everything else will be solved.We have to face a very embarrassing fact, that is,\\\",\\\"nXjGopiM\\\":\\\"Roussesaid a famous wordu said a famous word, wsaid a famous wordsting time is said a famous word gresaid a famous wordt sin. This inspired me.To understand what kind of eTopicistence Topic is is the key to solving all problems.\\\",\\\"r46NUn0lRtGS\\\":\\\"\u672c\u4eba\u4e5f\u662f\u7ecf\u8fc7\u4e86\u6df1\u601d\u719f\u8651,\u5728\u6bcf\u4e2a\u65e5\u65e5\u591c\u591c\u601d\u8003\u8fd9\u4e2a\u95ee\u9898. \u7ecf\u8fc7\u4e0a\u8ff0\u8ba8\u8bba, \u73b0\u5728, \u89e3\u51b3\u4e3b\u9898\u7684\u95ee\u9898, \u662f\u975e\u5e38\u975e\u5e38\u91cd\u8981\u7684. \u6240\u4ee5, \u4e3b\u9898\u56e0\u4f55\u800c\u53d1\u751f?\u8fd9\u79cd\u4e8b\u5b9e\u5bf9\u672c\u4eba\u6765\u8bf4\u610f\u4e49\u91cd\u5927, \u76f8\u4fe1\u5bf9\u8fd9\u4e2a\u4e16\u754c\u4e5f\u662f\u6709\u4e00\u5b9a\u610f\u4e49\u7684.\u6240\u8c13\u4e3b\u9898, \u5173\u952e\u662f\u4e3b\u9898\u9700\u8981\u5982\u4f55\u5199. \\\",\\\"sZfREtejPnpULNCOw4DmAq\\\":\\\"\u6211\u8ba4\u4e3a, \u8fd9\u662f\u4e0d\u53ef\u907f\u514d\u7684. \u4e3b\u9898, \u53d1\u751f\u4e86\u4f1a\u5982\u4f55, \u4e0d\u53d1\u751f\u53c8\u4f1a\u5982\u4f55. \u672c\u4eba\u4e5f\u662f\u7ecf\u8fc7\u4e86\u6df1\u601d\u719f\u8651,\u5728\u6bcf\u4e2a\u65e5\u65e5\u591c\u591c\u601d\u8003\u8fd9\u4e2a\u95ee\u9898. \u53ef\u662f\uff0c\u5373\u4f7f\u662f\u8fd9\u6837\uff0c\u4e3b\u9898\u7684\u51fa\u73b0\u4ecd\u7136\u4ee3\u8868\u4e86\u4e00\u5b9a\u7684\u610f\u4e49. \u6211\u4eec\u90fd\u77e5\u9053, \u53ea\u8981\u6709\u610f\u4e49, \u90a3\u4e48\u5c31\u5fc5\u987b\u614e\u91cd\u8003\u8651.\\\",\\\"uJRIv7MtldFZVhaoKH8\\\":\\\"Shsaid a famous wordkespesaid a famous wordre said a famous word, the wisdom in his hesaid a famous wordd is like the spsaid a famous wordrk in the flint, said a famous wordnd he will not come out without hitting it. This does not prohibit me from thinking deeply.\\\",\\\"vcnZETQ\\\":\\\"Everyone has to face these problems. When facing such problems,This is inevitable.These are not completely important. The more important question is,Hegel said a famous word, only those who said a famous wordlwsaid a famous wordys lie in the mud pit will never fsaid a famous wordll into the pit said a famous wordgsaid a famous wordin. This sentence seems simple, but its gloom can not help but make people think deeply.\\\",\\\"wEXa9KSIzj\\\":\\\"Under this inevitable conflict, we must solve this problem.With these problems, let's eTopicamine Topic.Binadvertently saidi Zhete inadvertently said, strong finadvertently saidith cinadvertently saidn win the heinadvertently saidrts of strong people inadvertently saidnd minadvertently saidke them stronger. Although this sentence is very short, it makes me daydream.\\\",\\\"yCntsBcU0XiO7PaFKL3w\\\":\\\"We have to face a very embarrassing fact, that is,How does Topic happen? How does Topic happen? How does Topic happen?Feng Xuefeng said a philosophical word, when said a philosophical word person uses his work to meet the light, the light will soon shine on him. This does not prohibit me from thinking deeply.\\\",\\\"yx01fvro9uijbpH7a\\\":\\\"\u4e00\u822c\u6765\u8bf4, \u6bcf\u4e2a\u4eba\u90fd\u4e0d\u5f97\u4e0d\u9762\u5bf9\u8fd9\u4e9b\u95ee\u9898.  \u5728\u9762\u5bf9\u8fd9\u79cd\u95ee\u9898\u65f6, \u90a3\u4e48, \u95ee\u9898\u7684\u5173\u952e\u7a76\u7adf\u4e3a\u4f55? \u53d4\u672c\u534e\u5728\u4e0d\u7ecf\u610f\u95f4\u8fd9\u6837\u8bf4\u8fc7, \u666e\u901a\u4eba\u53ea\u60f3\u5230\u5982\u4f55\u5ea6\u8fc7\u65f6\u95f4\uff0c\u6709\u624d\u80fd\u7684\u4eba\u8bbe\u6cd5\u5229\u7528\u65f6\u95f4\u3002\u5e26\u7740\u8fd9\u53e5\u8bdd, \u6211\u4eec\u8fd8\u8981\u66f4\u52a0\u614e\u91cd\u7684\u5ba1\u89c6\u8fd9\u4e2a\u95ee\u9898: \\\"}\\n\",\"rspBody\":\"{\\\"3SgfdDQYU2Lv1liyHRET90\\\":\\\"\u603b\u7ed3\u7684\u6765\u8bf4, \u4e3b\u9898\u4f3c\u4e4e\u662f\u4e00\u79cd\u5de7\u5408\uff0c\u4f46\u5982\u679c\u6211\u4eec\u4ece\u4e00\u4e2a\u66f4\u5927\u7684\u89d2\u5ea6\u770b\u5f85\u95ee\u9898\uff0c\u8fd9\u4f3c\u4e4e\u662f\u4e00\u79cd\u4e0d\u53ef\u907f\u514d\u7684\u4e8b\u5b9e. \u7231\u8fea\u751f\u8bf4\u8fc7\u4e00\u53e5\u5bcc\u6709\u54f2\u7406\u7684\u8bdd, \u5931\u8d25\u4e5f\u662f\u6211\u9700\u8981\u7684\uff0c\u5b83\u548c\u6210\u529f\u5bf9\u6211\u4e00\u6837\u6709\u4ef7\u503c\u3002\u5e26\u7740\u8fd9\u53e5\u8bdd, \u6211\u4eec\u8fd8\u8981\u66f4\u52a0\u614e\u91cd\u7684\u5ba1\u89c6\u8fd9\u4e2a\u95ee\u9898: \\\",\\\"3fEMT\\\":\\\"\u65e2\u7136\u5982\u6b64, \u7231\u8fea\u751f\u8bf4\u8fc7\u4e00\u53e5\u5bcc\u6709\u54f2\u7406\u7684\u8bdd, \u5931\u8d25\u4e5f\u662f\u6211\u9700\u8981\u7684\uff0c\u5b83\u548c\u6210\u529f\u5bf9\u6211\u4e00\u6837\u6709\u4ef7\u503c\u3002\u8fd9\u53e5\u8bdd\u8bed\u867d\u7136\u5f88\u77ed, \u4f46\u4ee4\u6211\u6d6e\u60f3\u8054\u7fe9. \u6b4c\u5fb7\u5728\u4e0d\u7ecf\u610f\u95f4\u8fd9\u6837\u8bf4\u8fc7, \u6ca1\u6709\u4eba\u4e8b\u5148\u4e86\u89e3\u81ea\u5df1\u5230\u5e95\u6709\u591a\u5927\u7684\u529b\u91cf\uff0c\u76f4\u5230\u4ed6\u8bd5\u8fc7\u4ee5\u540e\u624d\u77e5\u9053\u3002\u8fd9\u53e5\u8bdd\u628a\u6211\u4eec\u5e26\u5230\u4e86\u4e00\u4e2a\u65b0\u7684\u7ef4\u5ea6\u53bb\u601d\u8003\u8fd9\u4e2a\u95ee\u9898: \\\",\\\"6YpqQ7sZG5yfDm\\\":\\\"To understand what kind of eTopicistence Topic is is the key to solving all problems.Bsaid a famous wordi Zhete said a famous word, strong fsaid a famous wordith csaid a famous wordn win the hesaid a famous wordrts of strong people said a famous wordnd msaid a famous wordke them stronger. Although this sentence is very short, it makes me daydream.\\\",\\\"BMxUCrhNvDi16Oy\\\":\\\"Now, it is very, very important to solve the problem of Topic. So,From this point of view,Topic, how should Topic be realized.But even so, the emergence of Topic still represents a certain significance.With these problems, let's eTopicamine Topic.\\\",\\\"CRc1G\\\":\\\"Everyone has to face these problems. When facing such problems,Under this inevitable conflict, we must solve this problem.The key is how to write Topic.Topic, how should Topic be realized.If Topic appears in life, we have to consider the fact that it appears.\\\",\\\"CUHGaRm0hvpe\\\":\\\"With these problems, let's eTopicamine Topic.What is the key to the problem?Oprinadvertently saidh Winfrey inadvertently said, whinadvertently saidt you This sentence seems simple, but its gloom can not help but make people think deeply.elieve, you will This sentence seems simple, but its gloom can not help but make people think deeply.ecome whinadvertently saidt kind of person. This sentence seems simple, but its gloom can not help but make people think deeply.\\\",\\\"ELYvsnzWKl5iNQ1ofTum6ywC\\\":\\\"\u5415\u51ef\u7279\u8bf4\u8fc7\u4e00\u53e5\u8457\u540d\u7684\u8bdd, \u751f\u547d\u4e0d\u53ef\u80fd\u6709\u4e24\u6b21\uff0c\u4f46\u8bb8\u591a\u4eba\u8fde\u4e00\u6b21\u4e5f\u4e0d\u5584\u4e8e\u5ea6\u8fc7\u3002\u8fd9\u4e0d\u7981\u4ee4\u6211\u6df1\u601d. \u65e2\u7136\u5982\u4f55, \u6211\u4eec\u4e0d\u5f97\u4e0d\u9762\u5bf9\u4e00\u4e2a\u975e\u5e38\u5c34\u5c2c\u7684\u4e8b\u5b9e, \u90a3\u5c31\u662f, \u5361\u8010\u57fa\u66fe\u7ecf\u63d0\u5230\u8fc7, \u4e00\u4e2a\u4e0d\u6ce8\u610f\u5c0f\u4e8b\u60c5\u7684\u4eba\uff0c\u6c38\u8fdc\u4e0d\u4f1a\u6210\u5c31\u5927\u4e8b\u4e1a\u3002\u8fd9\u53e5\u8bdd\u770b\u4f3c\u7b80\u5355\uff0c\u4f46\u5176\u4e2d\u7684\u9634\u90c1\u4e0d\u7981\u8ba9\u4eba\u6df1\u601d. \\\",\\\"H4JPs\\\":\\\"Guo Moruo inadvertently said, the decisive finadvertently saidctor for forming genius should This seems to answer my doubts.e diligence. This seems to answer my doubts.From this point of view,To understand what kind of eTopicistence Topic is is the key to solving all problems.\\\",\\\"KDlHL5p\\\":\\\"we might as well think like this:We should think clearly about what kind of eTopicistence Topic is.Why does Topic happen?Under this inevitable conflict, we must solve this problem.generally speaking, we must carefully consider.\\\",\\\"LJBsrHyOx0Vl\\\":\\\"We have to face a very embarrassing fact, that is,X seems to be a coincidence, but if we look at the problem from a larger angle, it seems to be an inevitable fact.X seems to be a coincidence, but if we look at the problem from a larger angle, it seems to be an inevitable fact.\\\",\\\"QO6e4ZBRVgkv\\\":\\\"\u4e86\u89e3\u6e05\u695a\u4e3b\u9898\u5230\u5e95\u662f\u4e00\u79cd\u600e\u4e48\u6837\u7684\u5b58\u5728, \u662f\u89e3\u51b3\u4e00\u5207\u95ee\u9898\u7684\u5173\u952e.\u7c73\u6b47\u6f58\u8bf4\u8fc7\u4e00\u53e5\u5bcc\u6709\u54f2\u7406\u7684\u8bdd, \u751f\u547d\u662f\u4e00\u6761\u8270\u9669\u7684\u5ce1\u8c37\uff0c\u53ea\u6709\u52c7\u6562\u7684\u4eba\u624d\u80fd\u901a\u8fc7\u3002\u8fd9\u542f\u53d1\u4e86\u6211. \u767d\u54f2\u7279\u66fe\u7ecf\u63d0\u5230\u8fc7, \u575a\u5f3a\u7684\u4fe1\u5ff5\u80fd\u8d62\u5f97\u5f3a\u8005\u7684\u5fc3\uff0c\u5e76\u4f7f\u4ed6\u4eec\u53d8\u5f97\u66f4\u575a\u5f3a\u3002 \u5e26\u7740\u8fd9\u53e5\u8bdd, \u6211\u4eec\u8fd8\u8981\u66f4\u52a0\u614e\u91cd\u7684\u5ba1\u89c6\u8fd9\u4e2a\u95ee\u9898: \\\",\\\"SezdZYksoqt6jgiaKB5C1xRh\\\":\\\"\u8fd9\u6837\u770b\u6765, \u603b\u7ed3\u7684\u6765\u8bf4, \u4e9a\u4f2f\u62c9\u7f55\u00b7\u6797\u80af\u8bf4\u8fc7\u4e00\u53e5\u8457\u540d\u7684\u8bdd, \u6211\u8fd9\u4e2a\u4eba\u8d70\u5f97\u5f88\u6162\uff0c\u4f46\u662f\u6211\u4ece\u4e0d\u540e\u9000\u3002\u8fd9\u4e0d\u7981\u4ee4\u6211\u6df1\u601d. \u4ece\u8fd9\u4e2a\u89d2\u5ea6\u6765\u770b, \u8981\u60f3\u6e05\u695a, \u4e3b\u9898, \u5230\u5e95\u662f\u4e00\u79cd\u600e\u4e48\u6837\u7684\u5b58\u5728. \u8fd9\u79cd\u4e8b\u5b9e\u5bf9\u672c\u4eba\u6765\u8bf4\u610f\u4e49\u91cd\u5927, \u76f8\u4fe1\u5bf9\u8fd9\u4e2a\u4e16\u754c\u4e5f\u662f\u6709\u4e00\u5b9a\u610f\u4e49\u7684.\\\",\\\"T89UhIFH1Jnmsxa0\\\":\\\"But even so, the emergence of Topic still represents a certain significance.. \\\\r\\\\n    The key is how to write Topic.We should think clearly about what kind of eTopicistence Topic is.Topic, how should Topic be realized.we might as well think like this:\\\",\\\"TPgGRjvrswixpJVeb4tOX\\\":\\\"\u65e2\u7136\u5982\u6b64, \u65e2\u7136\u5982\u4f55, \u5e26\u7740\u8fd9\u4e9b\u95ee\u9898, \u6211\u4eec\u6765\u5ba1\u89c6\u4e00\u4e0b\u4e3b\u9898. \u751f\u6d3b\u4e2d, \u82e5\u4e3b\u9898\u51fa\u73b0\u4e86, \u6211\u4eec\u5c31\u4e0d\u5f97\u4e0d\u8003\u8651\u5b83\u51fa\u73b0\u4e86\u7684\u4e8b\u5b9e. \u8981\u60f3\u6e05\u695a, \u4e3b\u9898, \u5230\u5e95\u662f\u4e00\u79cd\u600e\u4e48\u6837\u7684\u5b58\u5728. \u5728\u8fd9\u79cd\u56f0\u96be\u7684\u6289\u62e9\u4e0b, \u672c\u4eba\u601d\u6765\u60f3\u53bb, \u5bdd\u98df\u96be\u5b89.\\\",\\\"TU6C8QeZPdyVEgLj0iH1o\\\":\\\"We generally believe that if we grasp the key to the problem, everything else will be solved.How does Topic happen? How does Topic happen? How does Topic happen?For me, Topic is not only a major event, but also may change my life.\\\",\\\"TeZBjnuiXbgv6VK4pkGl5HRa\\\":\\\"Now, it is very, very important to solve the problem of Topic. So,Everyone has to face these problems. When facing such problems,How does Topic happen? How does Topic happen? How does Topic happen?Why does Topic happen?From this point of view,\\\",\\\"TfBsQOra\\\":\\\"With these problems, let's eTopicamine Topic.Fronce mentionednklin once mentioned, reonce mentionedding is eonce mentionedsy, thinking is difficult, This sentence seems simple, but its gloom can not help but make people think deeply.ut without one of the two, it is useless. This sentence seems simple, but its gloom can not help but make people think deeply.\\\",\\\"UgksCKAB9PfLWIidN3yRGx\\\":\\\"This is inevitable.we might as well think like this:. \\\\r\\\\n    But even so, the emergence of Topic still represents a certain significance.. \\\\r\\\\n    Topic, how should Topic be realized.Now, it is very, very important to solve the problem of Topic. So,\\\",\\\"WdP2CjJtXGFz\\\":\\\"The key is how to write Topic.Why does Topic happen?If Topic appears in life, we have to consider the fact that it appears.generally speaking, we must carefully consider.From this point of view,What is the key to the problem?\\\",\\\"XiZy6nME3J5x\\\":\\\"\u57f9\u6839\u8bf4\u8fc7\uff0c\u6df1\u7aa5\u81ea\u5df1\u7684\u5fc3\uff0c\u800c\u540e\u53d1\u89c9\u4e00\u5207\u7684\u5947\u8ff9\u5728\u4f60\u81ea\u5df1\u3002\u6211\u5e0c\u671b\u8bf8\u4f4d\u4e5f\u80fd\u597d\u597d\u5730\u4f53\u4f1a\u8fd9\u53e5\u8bdd. \u90a3\u4e48, \u5e26\u7740\u8fd9\u4e9b\u95ee\u9898, \u6211\u4eec\u6765\u5ba1\u89c6\u4e00\u4e0b\u4e3b\u9898. \u4e3b\u9898, \u5230\u5e95\u5e94\u8be5\u5982\u4f55\u5b9e\u73b0. \u4e00\u822c\u6765\u8bf4, \u5c31\u6211\u4e2a\u4eba\u6765\u8bf4, \u4e3b\u9898\u5bf9\u6211\u7684\u610f\u4e49, \u4e0d\u80fd\u4e0d\u8bf4\u975e\u5e38\u91cd\u5927. \\\",\\\"YAdQwSolt9\\\":\\\"generally speaking, we must carefully consider.X seems to be a coincidence, but if we look at the problem from a larger angle, it seems to be an inevitable fact.Why does Topic happen?Under this inevitable conflict, we must solve this problem.\\\",\\\"a41i3efHKBC\\\":\\\"These are not completely important. The more important question is,We should think clearly about what kind of eTopicistence Topic is.generally speaking, we must carefully consider.we might as well think like this:\\\",\\\"dYm2VoqPLpDkWch95EH0swMbI\\\":\\\"We should think clearly about what kind of eTopicistence Topic is.If Topic appears in life, we have to consider the fact that it appears.For me, Topic is not only a major event, but also may change my life. AI hope you can also understand this sentence well.rsaid a philosophical wordhsaid a philosophical wordm Lincoln said a philosophical word, I said a philosophical wordm said a philosophical word slow wsaid a philosophical wordlker, I hope you can also understand this sentence well.ut I never retresaid a philosophical wordt. I hope you can also understand this sentence well.\\\",\\\"e0VyHn6AjY8UvaPBlizLdNOF4\\\":\\\"For me, Topic is not only a major event, but also may change my life.What is the key to the problem?But even so, the emergence of Topic still represents a certain significance.This is inevitable.The key is how to write Topic.\\\",\\\"hOeat5ncrTs\\\":\\\"We generally believe that if we grasp the key to the problem, everything else will be solved.Everyone has to face these problems. When facing such problems,How does Topic happen? How does Topic happen? How does Topic happen?\\\",\\\"hYDte1gkB2XZaJS5rLqpOmT0N\\\":\\\". \\\\r\\\\n    X seems to be a coincidence, but if we look at the problem from a larger angle, it seems to be an inevitable fact.Now, it is very, very important to solve the problem of Topic. So,These are not completely important. The more important question is,\\\",\\\"kelKgTAj6iCLqQps\\\":\\\"We generally believe that if we grasp the key to the problem, everything else will be solved.This is inevitable.Goethe said a philosophical word, no one knows how powerful he is until he hsaid a philosophical words tried. This seems to answer my doubts.\\\",\\\"mRhDCy1ig8J9x6O0\\\":\\\"To understand what kind of eTopicistence Topic is is the key to solving all problems.We generally believe that if we grasp the key to the problem, everything else will be solved.We have to face a very embarrassing fact, that is,\\\",\\\"nXjGopiM\\\":\\\"Roussesaid a famous wordu said a famous word, wsaid a famous wordsting time is said a famous word gresaid a famous wordt sin. This inspired me.To understand what kind of eTopicistence Topic is is the key to solving all problems.\\\",\\\"r46NUn0lRtGS\\\":\\\"\u672c\u4eba\u4e5f\u662f\u7ecf\u8fc7\u4e86\u6df1\u601d\u719f\u8651,\u5728\u6bcf\u4e2a\u65e5\u65e5\u591c\u591c\u601d\u8003\u8fd9\u4e2a\u95ee\u9898. \u7ecf\u8fc7\u4e0a\u8ff0\u8ba8\u8bba, \u73b0\u5728, \u89e3\u51b3\u4e3b\u9898\u7684\u95ee\u9898, \u662f\u975e\u5e38\u975e\u5e38\u91cd\u8981\u7684. \u6240\u4ee5, \u4e3b\u9898\u56e0\u4f55\u800c\u53d1\u751f?\u8fd9\u79cd\u4e8b\u5b9e\u5bf9\u672c\u4eba\u6765\u8bf4\u610f\u4e49\u91cd\u5927, \u76f8\u4fe1\u5bf9\u8fd9\u4e2a\u4e16\u754c\u4e5f\u662f\u6709\u4e00\u5b9a\u610f\u4e49\u7684.\u6240\u8c13\u4e3b\u9898, \u5173\u952e\u662f\u4e3b\u9898\u9700\u8981\u5982\u4f55\u5199. \\\",\\\"sZfREtejPnpULNCOw4DmAq\\\":\\\"\u6211\u8ba4\u4e3a, \u8fd9\u662f\u4e0d\u53ef\u907f\u514d\u7684. \u4e3b\u9898, \u53d1\u751f\u4e86\u4f1a\u5982\u4f55, \u4e0d\u53d1\u751f\u53c8\u4f1a\u5982\u4f55. \u672c\u4eba\u4e5f\u662f\u7ecf\u8fc7\u4e86\u6df1\u601d\u719f\u8651,\u5728\u6bcf\u4e2a\u65e5\u65e5\u591c\u591c\u601d\u8003\u8fd9\u4e2a\u95ee\u9898. \u53ef\u662f\uff0c\u5373\u4f7f\u662f\u8fd9\u6837\uff0c\u4e3b\u9898\u7684\u51fa\u73b0\u4ecd\u7136\u4ee3\u8868\u4e86\u4e00\u5b9a\u7684\u610f\u4e49. \u6211\u4eec\u90fd\u77e5\u9053, \u53ea\u8981\u6709\u610f\u4e49, \u90a3\u4e48\u5c31\u5fc5\u987b\u614e\u91cd\u8003\u8651.\\\",\\\"uJRIv7MtldFZVhaoKH8\\\":\\\"Shsaid a famous wordkespesaid a famous wordre said a famous word, the wisdom in his hesaid a famous wordd is like the spsaid a famous wordrk in the flint, said a famous wordnd he will not come out without hitting it. This does not prohibit me from thinking deeply.\\\",\\\"vcnZETQ\\\":\\\"Everyone has to face these problems. When facing such problems,This is inevitable.These are not completely important. The more important question is,Hegel said a famous word, only those who said a famous wordlwsaid a famous wordys lie in the mud pit will never fsaid a famous wordll into the pit said a famous wordgsaid a famous wordin. This sentence seems simple, but its gloom can not help but make people think deeply.\\\",\\\"wEXa9KSIzj\\\":\\\"Under this inevitable conflict, we must solve this problem.With these problems, let's eTopicamine Topic.Binadvertently saidi Zhete inadvertently said, strong finadvertently saidith cinadvertently saidn win the heinadvertently saidrts of strong people inadvertently saidnd minadvertently saidke them stronger. Although this sentence is very short, it makes me daydream.\\\",\\\"yCntsBcU0XiO7PaFKL3w\\\":\\\"We have to face a very embarrassing fact, that is,How does Topic happen? How does Topic happen? How does Topic happen?Feng Xuefeng said a philosophical word, when said a philosophical word person uses his work to meet the light, the light will soon shine on him. This does not prohibit me from thinking deeply.\\\",\\\"yx01fvro9uijbpH7a\\\":\\\"\u4e00\u822c\u6765\u8bf4, \u6bcf\u4e2a\u4eba\u90fd\u4e0d\u5f97\u4e0d\u9762\u5bf9\u8fd9\u4e9b\u95ee\u9898.  \u5728\u9762\u5bf9\u8fd9\u79cd\u95ee\u9898\u65f6, \u90a3\u4e48, \u95ee\u9898\u7684\u5173\u952e\u7a76\u7adf\u4e3a\u4f55? \u53d4\u672c\u534e\u5728\u4e0d\u7ecf\u610f\u95f4\u8fd9\u6837\u8bf4\u8fc7, \u666e\u901a\u4eba\u53ea\u60f3\u5230\u5982\u4f55\u5ea6\u8fc7\u65f6\u95f4\uff0c\u6709\u624d\u80fd\u7684\u4eba\u8bbe\u6cd5\u5229\u7528\u65f6\u95f4\u3002\u5e26\u7740\u8fd9\u53e5\u8bdd, \u6211\u4eec\u8fd8\u8981\u66f4\u52a0\u614e\u91cd\u7684\u5ba1\u89c6\u8fd9\u4e2a\u95ee\u9898: \\\"}\\n\",\"reqPath\":\"/api/v1/test\"}\n";
    static byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
    static ObjectMapper mapper = new ObjectMapper();

    @Benchmark
    public void fastjson2(Blackhole bh) {
        bh.consume(JSON.parseObject((byte[])bytes, ApiLog.class));
    }

    @Benchmark
    public void fastjson2_str(Blackhole bh) {
        bh.consume(JSON.parseObject((String)str, ApiLog.class));
    }

    @Benchmark
    public void jackson(Blackhole bh) {
        bh.consume(mapper.readValue(bytes, ApiLog.class));
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().include(ParseUTF8BytesWithEscapeChars.class.getName()).mode(Mode.Throughput).warmupIterations(3).timeUnit(TimeUnit.MILLISECONDS).forks(1).build();
        new Runner(options).run();
    }

    public static class ApiLog {
        private Long timestamp;
        private String reqBody;
        private String rspBody;
    }
}

