/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark.twitter;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.benchmark.twitter.Twitter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class TwitterParseString {
    static String str;
    static final ObjectMapper mapper;
    static final Gson gson;

    @Benchmark
    public void fastjson2(Blackhole bh) {
        bh.consume(JSON.parseObject((String)str, Twitter.class));
    }

    @Benchmark
    public void jackson(Blackhole bh) throws Exception {
        bh.consume(mapper.readValue(str, Twitter.class));
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().include(TwitterParseString.class.getName()).mode(Mode.Throughput).timeUnit(TimeUnit.MILLISECONDS).warmupIterations(3).forks(1).threads(16).build();
        new Runner(options).run();
    }

    static {
        mapper = new ObjectMapper();
        gson = new Gson();
        try {
            InputStream is = TwitterParseString.class.getClassLoader().getResourceAsStream("data/twitter.json");
            str = IOUtils.toString((InputStream)is, (String)"UTF-8");
            JSON.parseObject((String)str, Twitter.class);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }
}

