/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark.jjb;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.benchmark.jjb.Users;
import com.dslplatform.json.DslJson;
import com.dslplatform.json.runtime.Settings;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import io.github.wycst.wast.json.options.WriteOption;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class UsersWriteUTF8Bytes {
    static Users users;
    static final ObjectMapper mapper;
    static final Gson gson;
    static final DslJson<Object> dslJson;
    static final ThreadLocal<ByteArrayOutputStream> bytesOutLocal;

    @Benchmark
    public void fastjson2(Blackhole bh) {
        bh.consume((Object)JSON.toJSONBytes((Object)users));
    }

    @Benchmark
    public void wast(Blackhole bh) {
        bh.consume((Object)io.github.wycst.wast.json.JSON.toJsonBytes((Object)users, (WriteOption[])new WriteOption[0]));
    }

    public void fastjson2_str(Blackhole bh) {
        bh.consume((Object)JSON.toJSONString((Object)users));
    }

    public void jsonb(Blackhole bh) {
        bh.consume((Object)JSONB.toBytes((Object)users));
    }

    public void jsonb_beanToArray(Blackhole bh) {
        bh.consume((Object)JSONB.toBytes((Object)users, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.BeanToArray, JSONWriter.Feature.FieldBased}));
    }

    @Benchmark
    public void dsljson(Blackhole bh) throws IOException {
        ByteArrayOutputStream bytesOut = bytesOutLocal.get();
        bytesOut.reset();
        dslJson.serialize((Object)users, (OutputStream)bytesOut);
        byte[] bytes = bytesOut.toByteArray();
        bh.consume((Object)bytes);
    }

    public void jackson(Blackhole bh) throws Exception {
        bh.consume((Object)mapper.writeValueAsBytes((Object)users));
    }

    public void gson(Blackhole bh) throws Exception {
        bh.consume((Object)gson.toJson((Object)users).getBytes(StandardCharsets.UTF_8));
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().include(UsersWriteUTF8Bytes.class.getName()).mode(Mode.Throughput).timeUnit(TimeUnit.MILLISECONDS).warmupIterations(3).forks(2).threads(16).build();
        new Runner(options).run();
    }

    static {
        mapper = new ObjectMapper();
        gson = new Gson();
        dslJson = new DslJson(Settings.withRuntime().includeServiceLoader());
        bytesOutLocal = ThreadLocal.withInitial(() -> new ByteArrayOutputStream());
        try {
            InputStream is = UsersWriteUTF8Bytes.class.getClassLoader().getResourceAsStream("data/jjb/user.json");
            String str = IOUtils.toString((InputStream)is, (String)"UTF-8");
            users = (Users)JSONReader.of((String)str).read(Users.class);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }
}

